/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2.video;

import android.os.Bundle;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import buzz.getcoco.exoplayer2.Bundleable;

public final class VideoSize
implements Bundleable {
    private static final int DEFAULT_WIDTH = 0;
    private static final int DEFAULT_HEIGHT = 0;
    private static final int DEFAULT_UNAPPLIED_ROTATION_DEGREES = 0;
    private static final float DEFAULT_PIXEL_WIDTH_HEIGHT_RATIO = 1.0f;
    public static final VideoSize UNKNOWN = new VideoSize(0, 0);
    @IntRange(from=0L)
    public final int width;
    @IntRange(from=0L)
    public final int height;
    @IntRange(from=0L, to=359L)
    public final int unappliedRotationDegrees;
    @FloatRange(from=0.0, fromInclusive=false)
    public final float pixelWidthHeightRatio;
    private static final int FIELD_WIDTH = 0;
    private static final int FIELD_HEIGHT = 1;
    private static final int FIELD_UNAPPLIED_ROTATION_DEGREES = 2;
    private static final int FIELD_PIXEL_WIDTH_HEIGHT_RATIO = 3;
    public static final Bundleable.Creator<VideoSize> CREATOR = bundle -> {
        int width = bundle.getInt(VideoSize.keyForField(0), 0);
        int height = bundle.getInt(VideoSize.keyForField(1), 0);
        int unappliedRotationDegrees = bundle.getInt(VideoSize.keyForField(2), 0);
        float pixelWidthHeightRatio = bundle.getFloat(VideoSize.keyForField(3), 1.0f);
        return new VideoSize(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
    };

    public VideoSize(@IntRange(from=0L) int width, @IntRange(from=0L) int height) {
        this(width, height, 0, 1.0f);
    }

    public VideoSize(@IntRange(from=0L) int width, @IntRange(from=0L) int height, @IntRange(from=0L, to=359L) int unappliedRotationDegrees, @FloatRange(from=0.0, fromInclusive=false) float pixelWidthHeightRatio) {
        this.width = width;
        this.height = height;
        this.unappliedRotationDegrees = unappliedRotationDegrees;
        this.pixelWidthHeightRatio = pixelWidthHeightRatio;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VideoSize) {
            VideoSize other = (VideoSize)obj;
            return this.width == other.width && this.height == other.height && this.unappliedRotationDegrees == other.unappliedRotationDegrees && this.pixelWidthHeightRatio == other.pixelWidthHeightRatio;
        }
        return false;
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.unappliedRotationDegrees;
        result = 31 * result + Float.floatToRawIntBits(this.pixelWidthHeightRatio);
        return result;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(VideoSize.keyForField(0), this.width);
        bundle.putInt(VideoSize.keyForField(1), this.height);
        bundle.putInt(VideoSize.keyForField(2), this.unappliedRotationDegrees);
        bundle.putFloat(VideoSize.keyForField(3), this.pixelWidthHeightRatio);
        return bundle;
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }
}

