/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2;

import android.os.Bundle;
import androidx.annotation.Nullable;
import buzz.getcoco.exoplayer2.Bundleable;
import buzz.getcoco.exoplayer2.source.TrackGroup;
import buzz.getcoco.exoplayer2.util.Assertions;
import buzz.getcoco.exoplayer2.util.BundleableUtil;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.util.Arrays;
import java.util.List;

public final class TracksInfo
implements Bundleable {
    private final ImmutableList<TrackGroupInfo> trackGroupInfos;
    public static final TracksInfo EMPTY = new TracksInfo((List<TrackGroupInfo>)ImmutableList.of());
    private static final int FIELD_TRACK_GROUP_INFOS = 0;
    public static final Bundleable.Creator<TracksInfo> CREATOR = bundle -> {
        List<TrackGroupInfo> trackGroupInfos = BundleableUtil.fromBundleNullableList(TrackGroupInfo.CREATOR, bundle.getParcelableArrayList(TracksInfo.keyForField(0)), ImmutableList.of());
        return new TracksInfo(trackGroupInfos);
    };

    public TracksInfo(List<TrackGroupInfo> trackGroupInfos) {
        this.trackGroupInfos = ImmutableList.copyOf(trackGroupInfos);
    }

    public ImmutableList<TrackGroupInfo> getTrackGroupInfos() {
        return this.trackGroupInfos;
    }

    public boolean isTypeSupportedOrEmpty(int trackType) {
        boolean supported = true;
        for (int i = 0; i < this.trackGroupInfos.size(); ++i) {
            if (((TrackGroupInfo)this.trackGroupInfos.get(i)).trackType != trackType) continue;
            if (((TrackGroupInfo)this.trackGroupInfos.get(i)).isSupported()) {
                return true;
            }
            supported = false;
        }
        return supported;
    }

    public boolean isTypeSelected(int trackType) {
        for (int i = 0; i < this.trackGroupInfos.size(); ++i) {
            TrackGroupInfo trackGroupInfo = (TrackGroupInfo)this.trackGroupInfos.get(i);
            if (!trackGroupInfo.isSelected() || trackGroupInfo.getTrackType() != trackType) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TracksInfo that = (TracksInfo)other;
        return this.trackGroupInfos.equals(that.trackGroupInfos);
    }

    public int hashCode() {
        return this.trackGroupInfos.hashCode();
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(TracksInfo.keyForField(0), BundleableUtil.toBundleArrayList(this.trackGroupInfos));
        return bundle;
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    public static final class TrackGroupInfo
    implements Bundleable {
        private final TrackGroup trackGroup;
        private final int[] trackSupport;
        private final int trackType;
        private final boolean[] trackSelected;
        private static final int FIELD_TRACK_GROUP = 0;
        private static final int FIELD_TRACK_SUPPORT = 1;
        private static final int FIELD_TRACK_TYPE = 2;
        private static final int FIELD_TRACK_SELECTED = 3;
        public static final Bundleable.Creator<TrackGroupInfo> CREATOR = bundle -> {
            TrackGroup trackGroup = BundleableUtil.fromNullableBundle(TrackGroup.CREATOR, bundle.getBundle(TrackGroupInfo.keyForField(0)));
            Assertions.checkNotNull(trackGroup);
            int[] trackSupport = (int[])MoreObjects.firstNonNull((Object)bundle.getIntArray(TrackGroupInfo.keyForField(1)), (Object)new int[trackGroup.length]);
            int trackType = bundle.getInt(TrackGroupInfo.keyForField(2), -1);
            boolean[] selected = (boolean[])MoreObjects.firstNonNull((Object)bundle.getBooleanArray(TrackGroupInfo.keyForField(3)), (Object)new boolean[trackGroup.length]);
            return new TrackGroupInfo(trackGroup, trackSupport, trackType, selected);
        };

        public TrackGroupInfo(TrackGroup trackGroup, int[] trackSupport, int trackType, boolean[] tracksSelected) {
            int length = trackGroup.length;
            Assertions.checkArgument(length == trackSupport.length && length == tracksSelected.length);
            this.trackGroup = trackGroup;
            this.trackSupport = (int[])trackSupport.clone();
            this.trackType = trackType;
            this.trackSelected = (boolean[])tracksSelected.clone();
        }

        public TrackGroup getTrackGroup() {
            return this.trackGroup;
        }

        public int getTrackSupport(int trackIndex) {
            return this.trackSupport[trackIndex];
        }

        public boolean isTrackSupported(int trackIndex) {
            return this.trackSupport[trackIndex] == 4;
        }

        public boolean isSelected() {
            return Booleans.contains((boolean[])this.trackSelected, (boolean)true);
        }

        public boolean isSupported() {
            for (int i = 0; i < this.trackSupport.length; ++i) {
                if (!this.isTrackSupported(i)) continue;
                return true;
            }
            return false;
        }

        public boolean isTrackSelected(int trackIndex) {
            return this.trackSelected[trackIndex];
        }

        public int getTrackType() {
            return this.trackType;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            TrackGroupInfo that = (TrackGroupInfo)other;
            return this.trackType == that.trackType && this.trackGroup.equals(that.trackGroup) && Arrays.equals(this.trackSupport, that.trackSupport) && Arrays.equals(this.trackSelected, that.trackSelected);
        }

        public int hashCode() {
            int result = this.trackGroup.hashCode();
            result = 31 * result + Arrays.hashCode(this.trackSupport);
            result = 31 * result + this.trackType;
            result = 31 * result + Arrays.hashCode(this.trackSelected);
            return result;
        }

        @Override
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putBundle(TrackGroupInfo.keyForField(0), this.trackGroup.toBundle());
            bundle.putIntArray(TrackGroupInfo.keyForField(1), this.trackSupport);
            bundle.putInt(TrackGroupInfo.keyForField(2), this.trackType);
            bundle.putBooleanArray(TrackGroupInfo.keyForField(3), this.trackSelected);
            return bundle;
        }

        private static String keyForField(int field) {
            return Integer.toString(field, 36);
        }
    }
}

