/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2;

import android.os.Bundle;
import androidx.annotation.CheckResult;
import androidx.annotation.FloatRange;
import androidx.annotation.Nullable;
import buzz.getcoco.exoplayer2.Bundleable;
import buzz.getcoco.exoplayer2.util.Assertions;
import buzz.getcoco.exoplayer2.util.Util;

public final class PlaybackParameters
implements Bundleable {
    public static final PlaybackParameters DEFAULT = new PlaybackParameters(1.0f);
    public final float speed;
    public final float pitch;
    private final int scaledUsPerMs;
    private static final int FIELD_SPEED = 0;
    private static final int FIELD_PITCH = 1;
    public static final Bundleable.Creator<PlaybackParameters> CREATOR = bundle -> {
        float speed = bundle.getFloat(PlaybackParameters.keyForField(0), 1.0f);
        float pitch = bundle.getFloat(PlaybackParameters.keyForField(1), 1.0f);
        return new PlaybackParameters(speed, pitch);
    };

    public PlaybackParameters(float speed) {
        this(speed, 1.0f);
    }

    public PlaybackParameters(@FloatRange(from=0.0, fromInclusive=false) float speed, @FloatRange(from=0.0, fromInclusive=false) float pitch) {
        Assertions.checkArgument(speed > 0.0f);
        Assertions.checkArgument(pitch > 0.0f);
        this.speed = speed;
        this.pitch = pitch;
        this.scaledUsPerMs = Math.round(speed * 1000.0f);
    }

    public long getMediaTimeUsForPlayoutTimeMs(long timeMs) {
        return timeMs * (long)this.scaledUsPerMs;
    }

    @CheckResult
    public PlaybackParameters withSpeed(@FloatRange(from=0.0, fromInclusive=false) float speed) {
        return new PlaybackParameters(speed, this.pitch);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlaybackParameters other = (PlaybackParameters)obj;
        return this.speed == other.speed && this.pitch == other.pitch;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Float.floatToRawIntBits(this.speed);
        result = 31 * result + Float.floatToRawIntBits(this.pitch);
        return result;
    }

    public String toString() {
        return Util.formatInvariant("PlaybackParameters(speed=%.2f, pitch=%.2f)", Float.valueOf(this.speed), Float.valueOf(this.pitch));
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putFloat(PlaybackParameters.keyForField(0), this.speed);
        bundle.putFloat(PlaybackParameters.keyForField(1), this.pitch);
        return bundle;
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }
}

