/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsReporter;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.IncrementalBuildExecutionDigest;
import com.github.eirslett.maven.plugins.frontend.lib.IncrementalMojoHelper;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.lib.YarnRunner;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import com.github.eirslett.maven.plugins.frontend.mojo.YarnUtils;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="yarn", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class YarnMojo
extends AbstractFrontendMojo {
    private static final String NPM_REGISTRY_URL = "npmRegistryURL";
    @Parameter(defaultValue="", property="frontend.yarn.arguments", required=false)
    private String arguments;
    @Parameter(defaultValue="true", property="frontend.incremental", required=false)
    private String frontendIncremental;
    @Parameter(property="frontend.yarn.yarnInheritsProxyConfigFromMaven", required=false, defaultValue="true")
    private boolean yarnInheritsProxyConfigFromMaven;
    @Parameter(property="npmRegistryURL", required=false, defaultValue="")
    private String npmRegistryURL;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="triggerFiles", required=false)
    private Set<File> triggerFiles;
    @Parameter(property="excludedFilenames", required=false, defaultValue=".node,node_modules,lcov-report,coverage,screenshots,build,dist,target,.idea,.history,tmp,.settings,.vscode,.git,dependency-reduced-pom.xml,.flattened-pom.xml")
    private Set<String> excludedFilenames;
    @Component
    private BuildContext buildContext;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;
    @Parameter(property="skip.yarn", defaultValue="${skip.yarn}")
    private boolean skip;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public synchronized void execute(FrontendPluginFactory factory) throws Exception {
        boolean isYarnBerry = YarnUtils.isYarnrcYamlFilePresent(this.session, this.workingDirectory);
        YarnRunner runner = factory.getYarnRunner(this.getProxyConfig(), this.getRegistryUrl(), isYarnBerry);
        IncrementalBuildExecutionDigest.ExecutionCoordinates coordinates = new IncrementalBuildExecutionDigest.ExecutionCoordinates(this.execution.getGoal(), this.execution.getExecutionId(), this.execution.getLifecyclePhase());
        IncrementalMojoHelper incrementalHelper = new IncrementalMojoHelper(this.frontendIncremental, coordinates, this.getTargetDir(), this.workingDirectory, this.triggerFiles, this.excludedFilenames);
        boolean incrementalEnabled = incrementalHelper.incrementalEnabled();
        boolean isIncremental = incrementalEnabled && incrementalHelper.canBeSkipped(this.arguments, runner.getRuntime(), this.environmentVariables, this.project.getArtifactId(), this.getFrontendMavenPluginVersion());
        AtlassianDevMetricsReporter.incrementExecutionCount((String)this.project.getArtifactId(), (String)this.arguments, (AtlassianDevMetricsReporter.Goal)AtlassianDevMetricsReporter.Goal.YARN, (String)this.getFrontendMavenPluginVersion(), (boolean)incrementalEnabled, (boolean)isIncremental, () -> {
            if (isIncremental) {
                this.getLog().info((CharSequence)("Skipping yarn execution as no modified files in " + this.workingDirectory));
            } else {
                runner.execute(this.arguments, this.environmentVariables);
                incrementalHelper.acceptIncrementalBuildDigest();
            }
        });
    }

    private ProxyConfig getProxyConfig() {
        if (this.yarnInheritsProxyConfigFromMaven) {
            return MojoUtils.getProxyConfig(this.session, this.decrypter);
        }
        this.getLog().info((CharSequence)"yarn not inheriting proxy config from Maven");
        return new ProxyConfig(Collections.emptyList());
    }

    private String getRegistryUrl() {
        return System.getProperty(NPM_REGISTRY_URL, this.npmRegistryURL);
    }
}

