/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsReporter;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.IncrementalBuildExecutionDigest;
import com.github.eirslett.maven.plugins.frontend.lib.IncrementalMojoHelper;
import com.github.eirslett.maven.plugins.frontend.lib.NpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="npm", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class NpmMojo
extends AbstractFrontendMojo {
    private static final String NPM_REGISTRY_URL = "npmRegistryURL";
    @Parameter(defaultValue="install", property="frontend.npm.arguments", required=false)
    private String arguments;
    @Parameter(defaultValue="true", property="frontend.incremental", required=false)
    private String frontendIncremental;
    @Parameter(property="frontend.npm.npmInheritsProxyConfigFromMaven", required=false, defaultValue="true")
    private boolean npmInheritsProxyConfigFromMaven;
    @Parameter(property="npmRegistryURL", required=false, defaultValue="")
    private String npmRegistryURL;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="triggerFiles", required=false)
    private Set<File> triggerFiles;
    @Parameter(property="excludedFilenames", defaultValue="node_modules,lcov-report,coverage,screenshots,build,dist,target,.idea,.history,tmp,.settings,.vscode,dependency-reduced-pom.xml", required=false)
    private Set<String> excludedFilenames;
    @Component
    private BuildContext buildContext;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;
    @Parameter(property="skip.npm", defaultValue="${skip.npm}")
    private boolean skip;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public synchronized void execute(FrontendPluginFactory factory) throws Exception {
        NpmRunner runner = factory.getNpmRunner(this.getProxyConfig(), this.getRegistryUrl());
        IncrementalMojoHelper incrementalHelper = new IncrementalMojoHelper(this.frontendIncremental, this.getTargetDir(), this.workingDirectory, this.triggerFiles, this.excludedFilenames);
        IncrementalBuildExecutionDigest.ExecutionCoordinates coordinates = new IncrementalBuildExecutionDigest.ExecutionCoordinates(this.execution.getGoal(), this.execution.getExecutionId(), this.execution.getLifecyclePhase());
        boolean incrementalEnabled = incrementalHelper.incrementalEnabled();
        boolean isIncremental = incrementalEnabled && incrementalHelper.canBeSkipped(this.arguments, coordinates, runner.getRuntime(), this.environmentVariables, this.project.getArtifactId(), this.getFrontendMavenPluginVersion());
        AtlassianDevMetricsReporter.incrementExecutionCount((String)this.project.getArtifactId(), (String)this.arguments, (AtlassianDevMetricsReporter.Goal)AtlassianDevMetricsReporter.Goal.NPM, (String)this.getFrontendMavenPluginVersion(), (boolean)incrementalEnabled, (boolean)isIncremental, () -> {
            if (isIncremental) {
                this.getLog().info((CharSequence)("Skipping npm execution as no modified files in " + this.workingDirectory));
            } else {
                runner.execute(this.arguments, this.environmentVariables);
                incrementalHelper.acceptIncrementalBuildDigest();
            }
        });
    }

    private ProxyConfig getProxyConfig() {
        if (this.npmInheritsProxyConfigFromMaven) {
            return MojoUtils.getProxyConfig(this.session, this.decrypter);
        }
        this.getLog().info((CharSequence)"npm not inheriting proxy config from Maven");
        return new ProxyConfig(Collections.emptyList());
    }

    private String getRegistryUrl() {
        return System.getProperty(NPM_REGISTRY_URL, this.npmRegistryURL);
    }
}

