/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsReporter;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="corepack", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class CorepackMojo
extends AbstractFrontendMojo {
    @Parameter(defaultValue="enable", property="frontend.corepack.arguments", required=false)
    private String arguments;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildContext buildContext;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;
    @Parameter(property="skip.corepack", defaultValue="${skip.corepack}")
    private boolean skip;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public synchronized void execute(FrontendPluginFactory factory) throws Exception {
        File packageJson = new File(this.workingDirectory, "package.json");
        boolean incrementalEnabled = MojoUtils.incrementalBuildEnabled(this.buildContext);
        boolean willBeIncremental = incrementalEnabled && this.buildContext.hasDelta(packageJson);
        AtlassianDevMetricsReporter.incrementExecutionCount((String)this.project.getArtifactId(), (String)this.arguments, (AtlassianDevMetricsReporter.Goal)AtlassianDevMetricsReporter.Goal.COREPACK, (String)this.getFrontendMavenPluginVersion(), (boolean)incrementalEnabled, (boolean)willBeIncremental, () -> {
            if (!willBeIncremental) {
                factory.getCorepackRunner().execute(this.arguments, this.environmentVariables);
            } else {
                this.getLog().info((CharSequence)"Skipping corepack install as package.json unchanged");
            }
        });
    }
}

