/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.CacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import com.github.eirslett.maven.plugins.frontend.mojo.RepositoryCacheResolver;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystemSession;

public abstract class AbstractFrontendMojo
extends AbstractMojo {
    @Component
    protected MojoExecution execution;
    @Component
    private PluginDescriptor pluginDescriptor;
    @Parameter(property="skipTests", required=false, defaultValue="false")
    protected Boolean skipTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    protected boolean testFailureIgnore;
    @Parameter(defaultValue="${basedir}", property="workingDirectory", required=false)
    protected File workingDirectory;
    @Parameter(property="installDirectory", required=false)
    protected File installDirectory;
    @Parameter
    protected Map<String, String> environmentVariables;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;

    private boolean skipTestPhase() {
        return this.skipTests != false && this.isTestingPhase();
    }

    private boolean isTestingPhase() {
        String phase = this.execution.getLifecyclePhase();
        return "test".equals(phase) || "integration-test".equals(phase);
    }

    protected abstract void execute(FrontendPluginFactory var1) throws Exception;

    protected abstract boolean skipExecution();

    public void execute() throws MojoFailureException {
        if (this.testFailureIgnore && !this.isTestingPhase()) {
            this.getLog().info((CharSequence)"testFailureIgnore property is ignored in non test phases");
        }
        if (!this.skipTestPhase() && !this.skipExecution()) {
            if (this.installDirectory == null) {
                this.installDirectory = this.workingDirectory;
            }
            try {
                this.execute(new FrontendPluginFactory(this.workingDirectory, this.installDirectory, (CacheResolver)new RepositoryCacheResolver(this.repositorySystemSession)));
            }
            catch (TaskRunnerException e) {
                if (this.testFailureIgnore && this.isTestingPhase()) {
                    this.getLog().error((CharSequence)("There are test failures.\nFailed to run task: " + e.getMessage()), (Throwable)e);
                }
                throw new MojoFailureException("Failed to run task", (Throwable)e);
            }
            catch (Exception e) {
                throw MojoUtils.toMojoFailureException(e);
            }
        } else {
            this.getLog().info((CharSequence)"Skipping execution.");
        }
    }

    protected Map<String, String> getHttpHeaders(Server server) {
        if (server == null || !(server.getConfiguration() instanceof Xpp3Dom)) {
            return Collections.emptyMap();
        }
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        HashMap<String, String> result = new HashMap<String, String>();
        Xpp3Dom httpHeaders = configuration.getChild("httpHeaders");
        if (httpHeaders != null) {
            for (Xpp3Dom property : httpHeaders.getChildren("property")) {
                Xpp3Dom name = property.getChild("name");
                Xpp3Dom value = property.getChild("value");
                if (name == null || value == null) continue;
                result.put(name.getValue(), value.getValue());
            }
        }
        return result;
    }

    String getFrontendMavenPluginVersion() {
        return this.pluginDescriptor.getVersion();
    }
}

