/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.CacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendException;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import com.github.eirslett.maven.plugins.frontend.mojo.RepositoryCacheResolver;
import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;

public abstract class AbstractFrontendMojo
extends AbstractMojo {
    @Component
    protected MojoExecution execution;
    @Parameter(property="skipTests", required=false, defaultValue="false")
    protected Boolean skipTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    protected boolean testFailureIgnore;
    @Parameter(defaultValue="${basedir}", property="workingDirectory", required=false)
    protected File workingDirectory;
    @Parameter(property="installDirectory", required=false)
    protected File installDirectory;
    @Parameter
    protected Map<String, String> environmentVariables;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter(property="useNodeVersionManager", defaultValue="true")
    private boolean useNodeVersionManager;

    private boolean skipTestPhase() {
        return this.skipTests != false && this.isTestingPhase();
    }

    private boolean isTestingPhase() {
        String phase = this.execution.getLifecyclePhase();
        return "test".equals(phase) || "integration-test".equals(phase);
    }

    protected abstract void execute(FrontendPluginFactory var1) throws FrontendException;

    protected abstract boolean skipExecution();

    public void execute() throws MojoFailureException {
        if (this.testFailureIgnore && !this.isTestingPhase()) {
            this.getLog().info((CharSequence)"testFailureIgnore property is ignored in non test phases");
        }
        if (!this.skipTestPhase() && !this.skipExecution()) {
            if (this.installDirectory == null) {
                this.installDirectory = this.workingDirectory;
            }
            try {
                this.execute(new FrontendPluginFactory(this.workingDirectory, this.installDirectory, (CacheResolver)new RepositoryCacheResolver(this.repositorySystemSession), this.useNodeVersionManager));
            }
            catch (TaskRunnerException e) {
                if (this.testFailureIgnore && this.isTestingPhase()) {
                    this.getLog().error((CharSequence)("There are test failures.\nFailed to run task: " + e.getMessage()), (Throwable)e);
                }
                throw new MojoFailureException("Failed to run task", (Throwable)e);
            }
            catch (FrontendException e) {
                throw MojoUtils.toMojoFailureException(e);
            }
        } else {
            this.getLog().info((CharSequence)"Skipping execution.");
        }
    }
}

