/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.I_CTypeValidate;
import org.ehrbase.validation.constraints.wrappers.IntervalComparator;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.CPRIMITIVE;
import org.openehr.schemas.v1.CREAL;
import org.openehr.schemas.v1.IntervalOfReal;

public class CReal
extends CConstraint
implements I_CTypeValidate {
    CReal(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object aValue, CPRIMITIVE cprimitive) throws IllegalArgumentException {
        CREAL creal = (CREAL)cprimitive;
        Float aFloat = null;
        if (aValue instanceof Double) {
            aFloat = Float.valueOf(((Double)aValue).floatValue());
        } else if (aValue instanceof Float) {
            aFloat = (Float)aValue;
        } else if (aValue instanceof Integer) {
            aFloat = Float.valueOf(((Integer)aValue).floatValue());
        } else {
            ValidationException.raise(path, "Value could not be handled (is it numerical?)" + aValue, "FLOAT01");
        }
        IntervalOfReal intervalOfReal = creal.getRange();
        if (intervalOfReal != null) {
            IntervalComparator.isWithinBoundaries(aFloat, intervalOfReal);
        }
        if (creal.sizeOfListArray() > 0 && !ArrayUtils.contains((float[])creal.getListArray(), (float)aFloat.floatValue())) {
            ValidationException.raise(path, "Real value does not match any values in constraint:" + aFloat, "FLOAT02");
        }
    }
}

