/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import com.nedap.archie.rm.datavalues.DvState;
import java.util.Map;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.I_CArchetypeConstraintValidate;
import org.openehr.schemas.v1.ARCHETYPECONSTRAINT;
import org.openehr.schemas.v1.CDVSTATE;
import org.openehr.schemas.v1.STATE;
import org.openehr.schemas.v1.STATEMACHINE;

public class CDvState
extends CConstraint
implements I_CArchetypeConstraintValidate {
    CDvState(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object aValue, ARCHETYPECONSTRAINT archetypeconstraint) throws IllegalArgumentException {
        if (!(archetypeconstraint instanceof CDVSTATE)) {
            throw new IllegalStateException("INTERNAL: archetype constraint is not a CDvState");
        }
        CDVSTATE cdvstate = (CDVSTATE)archetypeconstraint;
        DvState dvState = (DvState)aValue;
        if (cdvstate.getValue() != null) {
            STATEMACHINE statemachine = cdvstate.getValue();
            if (statemachine.sizeOfStatesArray() > 0) {
                for (STATE state : statemachine.getStatesArray()) {
                    if (dvState.getValue().getValue().equals(state.getName())) break;
                }
            }
            throw new IllegalArgumentException("Could not find a state matching:" + dvState.getValue());
        }
    }
}

