/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import com.nedap.archie.rm.datavalues.DvCodedText;
import java.util.Map;
import org.apache.xmlbeans.SchemaType;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.wrappers.CArchetypeConstraint;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.I_CArchetypeConstraintValidate;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.ARCHETYPECONSTRAINT;
import org.openehr.schemas.v1.CCODEPHRASE;
import org.openehr.schemas.v1.CCODEREFERENCE;
import org.openehr.schemas.v1.COBJECT;
import org.openehr.schemas.v1.CONSTRAINTREF;
import org.openehr.schemas.v1.CSINGLEATTRIBUTE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDvCodedText
extends CConstraint
implements I_CArchetypeConstraintValidate {
    private final Logger logger = LoggerFactory.getLogger(CDvCodedText.class);

    CDvCodedText(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object aValue, ARCHETYPECONSTRAINT archetypeconstraint) {
        CSINGLEATTRIBUTE csingleattribute;
        COBJECT cobject;
        DvCodedText checkValue = (DvCodedText)aValue;
        if (!(archetypeconstraint instanceof CSINGLEATTRIBUTE)) {
            ValidationException.raise(path, "Constraint for DvCodedText is not applicable:" + archetypeconstraint, "CODED_TEXT_03");
        }
        if ((cobject = (csingleattribute = (CSINGLEATTRIBUTE)archetypeconstraint).getChildrenArray(0)) != null) {
            SchemaType type = I_CArchetypeConstraintValidate.findSchemaType(I_CArchetypeConstraintValidate.getXmlType((ARCHETYPECONSTRAINT)cobject));
            cobject = (COBJECT)cobject.changeType(type);
        }
        if (cobject instanceof CCODEREFERENCE) {
            CCODEREFERENCE ccodereference = (CCODEREFERENCE)cobject;
            new CArchetypeConstraint(this.localTerminologyLookup, this.externalTerminologyValidator).validate(path, checkValue.getDefiningCode(), (ARCHETYPECONSTRAINT)ccodereference);
        } else if (cobject instanceof CCODEPHRASE) {
            CCODEPHRASE ccodephrase = (CCODEPHRASE)cobject;
            new CArchetypeConstraint(this.localTerminologyLookup, this.externalTerminologyValidator).validate(path, checkValue.getDefiningCode(), (ARCHETYPECONSTRAINT)ccodephrase);
            if (ccodephrase.isSetTerminologyId() && ccodephrase.getTerminologyId() != null && ccodephrase.getTerminologyId().getValue() != null && (ccodephrase.getTerminologyId().getValue().equals("local") || ccodephrase.getTerminologyId().getValue().equals("openehr"))) {
                this.checkCodedValue(path, checkValue);
            }
        } else if (cobject instanceof CONSTRAINTREF) {
            this.logger.warn("Constraint reference is not supported, path: {}", (Object)path);
        } else {
            ValidationException.raise(path, "Constraint child is not a code phrase constraint:" + cobject, "CODED_TEXT_02");
        }
    }

    private void checkCodedValue(String path, DvCodedText codedText) {
        if (this.localTerminologyLookup == null) {
            return;
        }
        for (Map lookup : this.localTerminologyLookup.values()) {
            if (!lookup.containsKey(codedText.getDefiningCode().getCodeString()) || !((String)lookup.get(codedText.getDefiningCode().getCodeString())).equals(codedText.getValue())) continue;
            return;
        }
        ValidationException.raise(path, "CodedText value is not valid:" + codedText.toString(), "CODED_TEXT_01");
    }
}

