/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import com.nedap.archie.datetime.DateTimeFormatters;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import java.time.temporal.Temporal;
import java.util.Map;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.util.DateTimeSyntax;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.I_CTypeValidate;
import org.ehrbase.validation.constraints.wrappers.IntervalComparator;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.CDATETIME;
import org.openehr.schemas.v1.CPRIMITIVE;

public class CDateTime
extends CConstraint
implements I_CTypeValidate {
    CDateTime(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object aValue, CPRIMITIVE cprimitive) throws IllegalArgumentException {
        if (!(aValue instanceof Temporal)) {
            ValidationException.raise(path, "INTERNAL: Time validation expects a java-date-time argument", "DATE_TIME_01");
        }
        CDATETIME cdatetime = (CDATETIME)cprimitive;
        String dvDateStr = DateTimeFormatters.ISO_8601_DATE_TIME.format((Temporal)aValue);
        new DateTimeSyntax(path, dvDateStr, cdatetime.isSetPattern() ? cdatetime.getPattern() : null).validate();
        DvDateTime dateTime = new DvDateTime(dvDateStr);
        if (cdatetime.isSetRange()) {
            IntervalComparator.isWithinBoundaries(dateTime, cdatetime.getRange());
        }
        this.validateTimeZone(path, dateTime, cdatetime);
    }

    private void validateTimeZone(String path, DvDateTime dvDateTime, CDATETIME cdatetime) throws IllegalArgumentException {
    }
}

