/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvDate;
import java.time.temporal.Temporal;
import java.util.Map;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.util.DateTimeSyntax;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.I_CTypeValidate;
import org.ehrbase.validation.constraints.wrappers.IntervalComparator;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.CDATE;
import org.openehr.schemas.v1.CPRIMITIVE;

public class CDate
extends CConstraint
implements I_CTypeValidate {
    CDate(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object aValue, CPRIMITIVE cprimitive) throws IllegalArgumentException {
        if (!(aValue instanceof Temporal)) {
            ValidationException.raise(path, "INTERNAL: Time validation expects a java-date-time argument", "DATE_01");
        }
        CDATE cdate = (CDATE)cprimitive;
        String dvDateStr = aValue.toString();
        new DateTimeSyntax(path, dvDateStr, cdate.isSetPattern() ? cdate.getPattern() : null).validate();
        DvDate date = new DvDate(dvDateStr);
        if (cdate.isSetRange()) {
            IntervalComparator.isWithinBoundaries(date, cdate.getRange());
        }
        this.validateTimeZone(path, date, cdate);
    }

    private void validateTimeZone(String path, DvDate dvDate, CDATE cdate) throws IllegalArgumentException {
    }
}

