/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.datavalues.DataValue;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.text.WordUtils;
import org.apache.xmlbeans.SchemaType;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.util.SnakeToCamel;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.CDvCodedText;
import org.ehrbase.validation.constraints.wrappers.CDvText;
import org.ehrbase.validation.constraints.wrappers.CMultipleAttribute;
import org.ehrbase.validation.constraints.wrappers.CSingleAttribute;
import org.ehrbase.validation.constraints.wrappers.I_CArchetypeConstraintValidate;
import org.ehrbase.validation.constraints.wrappers.IntervalComparator;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.ARCHETYPECONSTRAINT;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CMULTIPLEATTRIBUTE;
import org.openehr.schemas.v1.CSINGLEATTRIBUTE;

public class CAttribute
extends CConstraint
implements I_CArchetypeConstraintValidate {
    private boolean isAttributeResolved = false;

    CAttribute(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object aValue, ARCHETYPECONSTRAINT archetypeconstraint) {
        SchemaType type = I_CArchetypeConstraintValidate.findSchemaType(I_CArchetypeConstraintValidate.getXmlType(archetypeconstraint));
        CATTRIBUTE cattribute = (CATTRIBUTE)archetypeconstraint.changeType(type);
        if (cattribute.getRmAttributeName().equals("defining_code")) {
            if (aValue instanceof DvCodedText) {
                new CDvCodedText(this.localTerminologyLookup, this.externalTerminologyValidator).validate(path, aValue, (ARCHETYPECONSTRAINT)cattribute);
            } else if (aValue instanceof DvText) {
                new CDvText(this.localTerminologyLookup, this.externalTerminologyValidator).validate(path, aValue, (ARCHETYPECONSTRAINT)cattribute);
            }
            return;
        }
        Object value = this.findAttribute(aValue, cattribute.getRmAttributeName());
        if (value == null && IntervalComparator.isOptional(cattribute.getExistence())) {
            return;
        }
        if (!this.isAttributeResolved && value == null) {
            value = this.getFunctionValue(aValue, cattribute.getRmAttributeName());
            if (!this.isAttributeResolved) {
                ValidationException.raise(path, "The following attribute:" + cattribute.getRmAttributeName() + " is expected in object:" + aValue, "ATTR01");
            }
        }
        if (value == null) {
            ValidationException.raise(path, "Mandatory attribute has no value:" + cattribute.getRmAttributeName(), "ATTR02");
        } else if (value.getClass().isEnum()) {
            value = this.getEnumValue(path, value);
        }
        if (cattribute instanceof CSINGLEATTRIBUTE) {
            new CSingleAttribute(this.localTerminologyLookup, this.externalTerminologyValidator).validate(path, value, (ARCHETYPECONSTRAINT)cattribute);
        } else if (cattribute instanceof CMULTIPLEATTRIBUTE) {
            new CMultipleAttribute(this.localTerminologyLookup, this.externalTerminologyValidator).validate(path, value, (ARCHETYPECONSTRAINT)cattribute);
        }
    }

    private Object findAttribute(Object object, String attribute) {
        if (object instanceof Locatable) {
            return ((Locatable)object).itemAtPath("/" + attribute);
        }
        if (object instanceof DataValue) {
            return this.getAttributeValue(object, attribute);
        }
        return null;
    }

    private Object getAttributeValue(Object obj, String attribute) {
        Class<?> rmClass = obj.getClass();
        Object value = null;
        String getterName = "get" + new SnakeToCamel(attribute).convert();
        try {
            Method getter = rmClass.getMethod(getterName, new Class[0]);
            this.isAttributeResolved = true;
            value = getter.invoke(obj, null);
        }
        catch (Exception e) {
            this.isAttributeResolved = false;
        }
        return value;
    }

    private Object getFunctionValue(Object obj, String attribute) {
        Class<?> rmClass = obj.getClass();
        Object value = null;
        String functionName = WordUtils.uncapitalize((String)new SnakeToCamel(attribute).convert());
        try {
            Method function = rmClass.getMethod(functionName, new Class[0]);
            this.isAttributeResolved = true;
            value = function.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            this.isAttributeResolved = false;
        }
        return value;
    }

    private Object getEnumValue(String path, Object obj) {
        Class<?> rmClass = obj.getClass();
        Object value = null;
        try {
            Method getter = rmClass.getMethod("getValue", new Class[0]);
            value = getter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            ValidationException.raise(path, "Couldn't handle enum value", e.getMessage());
        }
        return value;
    }
}

