/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.terminology;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.nedap.archie.rm.datatypes.CodePhrase;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationException;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirTerminologyValidationSupport
implements ExternalTerminologyValidationSupport {
    private static final String CODE_SYSTEM_PREFIX = "terminology://fhir.hl7.org/CodeSystem";
    private static final String VALUE_SET_PREFIX = "terminology://fhir.hl7.org/ValueSet/$expand";
    private static final Logger LOG = LoggerFactory.getLogger(FhirTerminologyValidationSupport.class);
    private final String baseUrl;
    private final boolean failOnError;
    private final Executor executor;

    public FhirTerminologyValidationSupport(String baseUrl) {
        this(baseUrl, true);
    }

    public FhirTerminologyValidationSupport(String baseUrl, boolean failOnError) {
        this(baseUrl, failOnError, (HttpClient)HttpClients.createDefault());
    }

    public FhirTerminologyValidationSupport(String baseUrl, boolean failOnError, HttpClient httpClient) {
        this.baseUrl = baseUrl;
        this.failOnError = failOnError;
        this.executor = Executor.newInstance((HttpClient)httpClient);
    }

    @Override
    public boolean supports(String referenceSetUri) {
        DocumentContext context;
        if (!this.isCodeSystem(referenceSetUri) && !this.isValueSet(referenceSetUri)) {
            return false;
        }
        try {
            context = this.internalGet(this.buildUri(referenceSetUri));
        }
        catch (IOException e) {
            if (this.failOnError) {
                throw new ExternalTerminologyValidationException("An error occurred while checking if FHIR terminology server supports the referenceSetUri: " + referenceSetUri, e);
            }
            LOG.warn("The following error occurred: {}", (Object)e.getMessage());
            return false;
        }
        int total = (Integer)context.read("$.total", Integer.TYPE, new Predicate[0]);
        return total > 0;
    }

    @Override
    public void validate(String path, String referenceSetUri, CodePhrase codePhrase) {
        String url = this.extractUrl(referenceSetUri);
        if (!StringUtils.equals((CharSequence)url, (CharSequence)codePhrase.getTerminologyId().getValue())) {
            ValidationException.raise(path, "CodePhrase terminology does not match, expected: " + url + ", found: " + codePhrase.getTerminologyId().getValue(), "CODE_PHRASE_02");
        }
        if (this.isCodeSystem(referenceSetUri)) {
            this.validateCode(path, url, codePhrase);
        } else if (this.isValueSet(referenceSetUri)) {
            this.expandValueSet(path, url, codePhrase);
        }
    }

    private void validateCode(String path, String url, CodePhrase codePhrase) {
        DocumentContext context;
        try {
            context = this.internalGet(this.baseUrl + "/CodeSystem/$validate-code?url=" + url + "&code=" + codePhrase.getCodeString());
        }
        catch (IOException e) {
            if (this.failOnError) {
                throw new ExternalTerminologyValidationException("An error occurred while validating the code in CodeSystem", e);
            }
            LOG.warn("An error occurred while validating the code in CodeSystem: {}", (Object)e.getMessage());
            return;
        }
        boolean result = (Boolean)context.read("$.parameter[0].valueBoolean", Boolean.TYPE, new Predicate[0]);
        if (!result) {
            String message = (String)context.read("$.parameter[1].valueString", String.class, new Predicate[0]);
            ValidationException.raise(path, message, "CODE_PHRASE_03");
        }
    }

    private void expandValueSet(String path, String url, CodePhrase codePhrase) {
        DocumentContext context;
        try {
            context = this.internalGet(this.baseUrl + "/ValueSet/$expand?url=" + url);
        }
        catch (IOException e) {
            if (this.failOnError) {
                throw new ExternalTerminologyValidationException("An error occurred while expanding the ValueSet", e);
            }
            LOG.warn("An error occurred while expanding the ValueSet: {}", (Object)e.getMessage());
            return;
        }
        String[] codes = (String[])context.read("$.expansion.contains[*].code", String[].class, new Predicate[0]);
        if (!Arrays.asList(codes).contains(codePhrase.getCodeString())) {
            ValidationException.raise(path, "CodePhrase codeString does not match any option, found:" + codePhrase.getCodeString(), "CODE_PHRASE_03");
        }
    }

    private boolean isCodeSystem(String referenceSetUri) {
        return StringUtils.startsWith((CharSequence)referenceSetUri, (CharSequence)CODE_SYSTEM_PREFIX);
    }

    private boolean isValueSet(String referenceSetUri) {
        return StringUtils.startsWith((CharSequence)referenceSetUri, (CharSequence)VALUE_SET_PREFIX);
    }

    private String buildUri(String referenceSetUri) {
        return this.baseUrl + (String)(this.isCodeSystem(referenceSetUri) ? "/CodeSystem" : "/ValueSet?url=" + this.extractUrl(referenceSetUri));
    }

    private String extractUrl(String referenceSetUri) {
        return StringUtils.substringAfter((String)referenceSetUri, (String)"url=");
    }

    private DocumentContext internalGet(String uri) throws IOException {
        Request request = Request.Get((String)uri).addHeader("Accept", "application/fhir+json");
        HttpResponse response = this.executor.execute(request).returnResponse();
        String responseBody = Optional.ofNullable(response.getEntity()).map(entity -> {
            try {
                return EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                return null;
            }
        }).orElse("");
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new ExternalTerminologyValidationException("Error response received from the terminology server. HTTP status: " + statusCode + ". Body: " + responseBody);
        }
        return JsonPath.parse((String)responseBody);
    }
}

