/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datastructures.ItemStructure;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ehrbase.validation.Cardinality;
import org.ehrbase.validation.Message;
import org.ehrbase.validation.constraints.ConstraintMapper;
import org.ehrbase.validation.constraints.OptConstraintMapper;
import org.ehrbase.validation.constraints.hardwired.CHistory;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.util.LocatableHelper;
import org.ehrbase.validation.constraints.wrappers.CArchetypeConstraint;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.ARCHETYPECONSTRAINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintChecker {
    private final Logger log = LoggerFactory.getLogger(ConstraintChecker.class);
    private final boolean lenient;
    private final ConstraintMapper constraintMapper;
    private final Locatable locatable;
    private final Cardinality cardinality;
    private final ExternalTerminologyValidationSupport externalTerminologyValidator;

    public ConstraintChecker(Boolean lenient, Composition composition, ConstraintMapper constraintMapper, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        this.lenient = lenient;
        this.locatable = composition;
        this.constraintMapper = constraintMapper;
        this.externalTerminologyValidator = externalTerminologyValidator;
        this.cardinality = new Cardinality(constraintMapper, this.locatable, lenient);
    }

    public ConstraintChecker(Boolean lenient, ItemStructure structure, ConstraintMapper constraintMapper, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        this.lenient = lenient;
        this.locatable = structure;
        this.constraintMapper = constraintMapper;
        this.externalTerminologyValidator = externalTerminologyValidator;
        this.cardinality = new Cardinality(constraintMapper, this.locatable, lenient);
    }

    private void validateElement(String path, Element referenceElement) {
        if (this.lenient) {
            return;
        }
        List<ConstraintMapper.ConstraintItem> constraints = this.constraintMapper.getConstraintItem(LocatableHelper.siblingPath(path));
        if (constraints == null) {
            String tentativePath = LocatableHelper.simplifyPath(path);
            Object tentativeElement = this.locatable.itemAtPath(tentativePath);
            if (tentativeElement == null) {
                this.log.debug("No constraint matching element (node could not be identified):" + tentativePath);
            } else if (tentativeElement instanceof Element) {
                constraints = this.constraintMapper.getConstraintItem(tentativePath);
                if (constraints == null) {
                    this.log.debug("No constraint matching element:" + tentativeElement);
                } else {
                    this.checkElementConstraints(constraints, path, referenceElement);
                }
            } else {
                this.log.debug("identified node is not an Element..." + tentativeElement);
            }
        } else {
            this.checkElementConstraints(constraints, path, referenceElement);
        }
    }

    private void checkElementConstraints(List<ConstraintMapper.ConstraintItem> constraints, String path, Element referenceElement) {
        Throwable exception = null;
        for (ConstraintMapper.ConstraintItem constraintItem : constraints) {
            try {
                if (!(constraintItem instanceof OptConstraintMapper.OptConstraintItem)) {
                    throw new IllegalStateException("Unhandled constraint");
                }
                OptConstraintMapper.OptConstraintItem optConstraintItem = (OptConstraintMapper.OptConstraintItem)constraintItem;
                new CArchetypeConstraint(this.constraintMapper.getLocalTerminologyLookup(), this.externalTerminologyValidator).validate(optConstraintItem.getPath(), referenceElement, (ARCHETYPECONSTRAINT)optConstraintItem.getConstraint());
                exception = null;
                break;
            }
            catch (ValidationException e) {
                exception = e;
            }
        }
        if (exception != null) {
            ValidationException.raise(path, exception.getMessage(), "ELT02");
        }
    }

    private void validateItem(String path, Object item) {
        if (this.lenient || item == null) {
            return;
        }
        if (item instanceof History) {
            new CHistory(this.constraintMapper).validate(LocatableHelper.simplifyPath(path), item);
        } else if (item instanceof Element) {
            this.validateElement(path, (Element)item);
        } else {
            ValidationException.raise(path, "Unhandled specific data type:" + item, "HIST01");
        }
    }

    private String validateElements() {
        if (this.lenient) {
            return "";
        }
        if (this.constraintMapper == null) {
            return "";
        }
        StringBuilder validationException = new StringBuilder();
        Iterator<Map.Entry<String, List<ConstraintMapper.ConstraintItem>>> iterator = this.constraintMapper.getElementConstraintIterator();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            Map.Entry<String, List<ConstraintMapper.ConstraintItem>> watch = iterator.next();
            String path = watch.getKey();
            for (Object pathItem : this.locatable.itemsAtPath(path)) {
                if (!(pathItem instanceof Locatable)) continue;
                Locatable item = (Locatable)pathItem;
                ConstraintMapper.CardinalityItem cardinalityItem = this.constraintMapper.getCardinalityList().get(path);
                if (cardinalityItem != null) {
                    this.cardinality.check(item, path, cardinalityItem);
                }
                try {
                    if (!(item instanceof Element) || this.isNilElement((Element)item)) continue;
                    this.validateItem(path, item);
                }
                catch (Exception e) {
                    validationException.append(new Message().encode(path, e.getMessage(), "")).append("\n");
                }
            }
        }
        this.log.debug("Validated " + count + " elements");
        return validationException.toString();
    }

    public void validate() {
        StringBuilder exceptions = new StringBuilder();
        exceptions.append(this.validateElements());
        exceptions.append(this.cardinality.validate());
        if (exceptions.length() > 0) {
            ValidationException.raise("", exceptions.toString(), "");
        } else {
            this.log.debug("Locatable successfully validated");
        }
    }

    private boolean isNilElement(Element element) {
        return element.getNullFlavour() == null && element.getValue() == null;
    }
}

