/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation;

import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.datastructures.ItemStructure;
import java.io.Serializable;
import org.ehrbase.validation.constraints.ConstraintChecker;
import org.ehrbase.validation.constraints.ConstraintMapper;
import org.ehrbase.validation.constraints.OptConstraint;
import org.ehrbase.validation.constraints.OptConstraintMapper;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;

public class Validator
implements Serializable {
    private boolean lenient = false;
    private OptConstraintMapper optConstraint;
    private ExternalTerminologyValidationSupport externalTerminologyValidator;

    public Validator(OPERATIONALTEMPLATE operationaltemplate, boolean lenient) {
        this.lenient = lenient;
    }

    public Validator(OPERATIONALTEMPLATE operationaltemplate) throws IllegalArgumentException {
        this.optConstraint = new OptConstraint().map(operationaltemplate);
    }

    public void check(Composition composition) throws IllegalArgumentException {
        new ConstraintChecker((Boolean)this.lenient, composition, (ConstraintMapper)this.optConstraint, this.externalTerminologyValidator).validate();
    }

    public void check(ItemStructure itemStructure) throws IllegalArgumentException {
        new ConstraintChecker((Boolean)this.lenient, itemStructure, (ConstraintMapper)this.optConstraint, this.externalTerminologyValidator).validate();
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void setExternalTerminologyValidator(ExternalTerminologyValidationSupport externalTerminologyValidator) {
        this.externalTerminologyValidator = externalTerminologyValidator;
    }
}

