/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.webtemplate;

import com.nedap.archie.rm.composition.IsmTransition;
import com.nedap.archie.rm.datavalues.DvCodedText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.client.classgenerator.shareddefinition.State;
import org.ehrbase.client.classgenerator.shareddefinition.Transition;
import org.ehrbase.functional.Either;
import org.ehrbase.validation.ConstraintViolation;
import org.ehrbase.validation.webtemplate.ConstraintValidator;
import org.ehrbase.webtemplate.model.WebTemplateNode;

public class IsmTransitionValidator
implements ConstraintValidator<IsmTransition> {
    public Class<IsmTransition> getAssociatedClass() {
        return IsmTransition.class;
    }

    @Override
    public List<ConstraintViolation> validate(IsmTransition transition, WebTemplateNode node) {
        ArrayList<ConstraintViolation> constraintViolations = new ArrayList<ConstraintViolation>();
        constraintViolations.addAll(new CurrentStateValidator().apply(transition, node));
        constraintViolations.addAll(new CareFlowValidator().apply(transition, node));
        return constraintViolations;
    }

    private String ismToString(IsmTransition ism) {
        return ism.getTransition().getValue() + "/" + ism.getTransition().getDefiningCode().getTerminologyId().getValue() + "/" + ism.getTransition().getDefiningCode().getCodeString();
    }

    private class CareFlowValidator
    implements BiFunction<IsmTransition, WebTemplateNode, List<ConstraintViolation>> {
        private CareFlowValidator() {
        }

        @Override
        public List<ConstraintViolation> apply(IsmTransition transition, WebTemplateNode node) {
            if (transition.getTransition() == null || transition.getCareflowStep() == null) {
                return Collections.emptyList();
            }
            Either<List<WebTemplateNode>, ConstraintViolation> careflows = this.extractCareflow(node);
            return (List)careflows.map((l, r) -> {
                if (careflows.isRight()) {
                    return List.of((ConstraintViolation)careflows.getAsRight());
                }
                Boolean isValid = ((List)careflows.getAsLeft()).stream().map(cf -> cf.getInputs()).flatMap(list -> list.stream()).flatMap(tmpl -> tmpl.getList().stream()).filter(tmpl -> this.isMatchingCareflowStep(transition.getCareflowStep(), tmpl.getValue())).map(tmpl -> this.isCurrentStateValid(transition.getCurrentState(), tmpl.getCurrentStates())).findFirst().orElse(false);
                return isValid != false ? Collections.emptyList() : List.of(new ConstraintViolation(node.getAqlPath(), "IsmTransition contains invalid current_state"));
            });
        }

        private boolean isMatchingCareflowStep(DvCodedText cfsFromIsm, String codeFromWTV) {
            return cfsFromIsm.getDefiningCode().getCodeString().equals(codeFromWTV);
        }

        private boolean isCurrentStateValid(DvCodedText currentState, List<String> allowedStates) {
            return allowedStates.contains(currentState.getDefiningCode().getCodeString());
        }

        private Either<List<WebTemplateNode>, ConstraintViolation> extractCareflow(WebTemplateNode node) {
            List candiate = node.getChildren().stream().filter(n -> n.getAqlPath() != null).filter(n -> n.getAqlPath().endsWith("careflow_step")).collect(Collectors.toList());
            if (candiate.size() > 1) {
                return Either.right((Object)new ConstraintViolation(node.getAqlPath(), "Specification violation[too many careflow_step]"));
            }
            return Either.left(candiate);
        }
    }

    private class CurrentStateValidator
    implements BiFunction<IsmTransition, WebTemplateNode, List<ConstraintViolation>> {
        private static final String ERR_NO_VALID_TRANSITION = "No valid transition found for ism transition[%s]";

        private CurrentStateValidator() {
        }

        @Override
        public List<ConstraintViolation> apply(IsmTransition transition, WebTemplateNode node) {
            if (transition.getTransition() == null) {
                return Collections.emptyList();
            }
            List allTransitions = Optional.ofNullable(transition).map(ism -> this.candidates(Transition.class, t -> t.getValue().equals(ism.getTransition().getValue()), t -> t.getTerminologyId().equals(ism.getTransition().getDefiningCode().getTerminologyId().getValue()), t -> t.getCode().equals(ism.getTransition().getDefiningCode().getCodeString()))).orElseGet(() -> Collections.emptyList());
            return allTransitions.stream().map(t -> Pair.of((Object)this.isValidTransition(transition, (Transition)t), (Object)t)).filter(p -> (Boolean)p.getLeft() == false).map(p -> new ConstraintViolation(node.getAqlPath(), String.format(ERR_NO_VALID_TRANSITION, IsmTransitionValidator.this.ismToString(transition)))).collect(Collectors.toList());
        }

        public boolean isValidTransition(IsmTransition ism, Transition transition) {
            State targetState = transition.getTargetState();
            DvCodedText currentState = ism.getCurrentState();
            return targetState.getValue().equals(currentState.getValue()) && targetState.getTerminologyId().equals(currentState.getDefiningCode().getTerminologyId().getValue()) && targetState.getCode().equals(currentState.getDefiningCode().getCodeString());
        }

        private <E extends Enum<E>> List<E> candidates(Class<E> type, Predicate<E> ... pred) {
            Predicate<Enum> passAll = t -> Stream.of(pred).map(p -> p.test(t)).reduce(true, (b0, b1) -> b0 != false && b1 != false);
            return Stream.of((Enum[])type.getEnumConstants()).filter(passAll).collect(Collectors.toList());
        }
    }
}

