/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.webtemplate;

import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.primitives.CInteger;
import com.nedap.archie.aom.primitives.CReal;
import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.rm.datavalues.quantity.DvQuantity;
import java.util.ArrayList;
import java.util.List;
import org.ehrbase.validation.ConstraintViolation;
import org.ehrbase.validation.webtemplate.ConstraintValidator;
import org.ehrbase.validation.webtemplate.PrimitiveConstraintMapper;
import org.ehrbase.validation.webtemplate.PrimitiveConstraintValidator;
import org.ehrbase.validation.webtemplate.WebTemplateValidationUtils;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateNode;

public class DvQuantityValidator
implements ConstraintValidator<DvQuantity> {
    private final PrimitiveConstraintMapper mapper = new PrimitiveConstraintMapper();
    private final PrimitiveConstraintValidator validator = new PrimitiveConstraintValidator();

    public Class<DvQuantity> getAssociatedClass() {
        return DvQuantity.class;
    }

    @Override
    public List<ConstraintViolation> validate(DvQuantity quantity, WebTemplateNode node) {
        ArrayList<ConstraintViolation> result = new ArrayList<ConstraintViolation>();
        WebTemplateValidationUtils.findInputWithSuffix(node, "magnitude").ifPresent(input -> result.addAll(this.validateMagnitude(node.getAqlPath(), quantity, (WebTemplateInput)input)));
        WebTemplateValidationUtils.findInputWithSuffix(node, "unit").ifPresent(input -> result.addAll(this.validateUnit(node.getAqlPath(), quantity, (WebTemplateInput)input)));
        return result;
    }

    private List<ConstraintViolation> validateMagnitude(String path, DvQuantity quantity, WebTemplateInput input) {
        return this.validator.validate(path, (Object)quantity.getMagnitude(), input);
    }

    private List<ConstraintViolation> validateUnit(String path, DvQuantity quantity, WebTemplateInput unitInput) {
        CString cString = this.mapper.mapTextInput(unitInput);
        List<ConstraintViolation> result = this.validator.validate(path, (Object)quantity.getUnits(), (CPrimitiveObject<?, ?>)cString);
        if (result.isEmpty()) {
            WebTemplateValidationUtils.findInputValue(unitInput, quantity.getUnits()).ifPresent(unitValue -> {
                if (WebTemplateValidationUtils.hasValidationRange(unitValue)) {
                    CReal cReal = this.mapper.mapRealInterval(unitValue.getValidation().getRange());
                    result.addAll(this.validator.validate(path, (Object)quantity.getMagnitude(), (CPrimitiveObject<?, ?>)cReal));
                }
                if (WebTemplateValidationUtils.hasValidationPrecision(unitValue) && quantity.getPrecision() != null) {
                    CInteger cInteger = this.mapper.mapIntegerInterval(unitValue.getValidation().getPrecision());
                    result.addAll(this.validator.validate(path, (Object)quantity.getPrecision(), (CPrimitiveObject<?, ?>)cInteger));
                }
            });
        }
        return result;
    }
}

