/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.webtemplate;

import com.nedap.archie.rm.datavalues.quantity.DvQuantified;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDuration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.serialisation.walker.DurationHelper;
import org.ehrbase.validation.ConstraintViolation;
import org.ehrbase.validation.webtemplate.ConstraintValidator;
import org.ehrbase.validation.webtemplate.PrimitiveConstraintValidator;
import org.ehrbase.validation.webtemplate.WebTemplateValidationUtils;
import org.ehrbase.webtemplate.model.WebTemplateComparisonSymbol;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.threeten.extra.PeriodDuration;

public class DvDurationValidator
implements ConstraintValidator<DvDuration> {
    private final PrimitiveConstraintValidator validator = new PrimitiveConstraintValidator();

    public Class<DvDuration> getAssociatedClass() {
        return DvDuration.class;
    }

    @Override
    public List<ConstraintViolation> validate(DvDuration dvDuration, WebTemplateNode node) {
        if (!WebTemplateValidationUtils.hasInputs(node)) {
            return Collections.emptyList();
        }
        ArrayList<ConstraintViolation> result = new ArrayList<ConstraintViolation>();
        PeriodDuration duration = PeriodDuration.from((TemporalAmount)dvDuration.getValue());
        Arrays.stream(DurationHelper.MIN_MAX.values()).map(m -> DurationHelper.getTotalComparisonSymbol((WebTemplateNode)node, (DurationHelper.MIN_MAX)m).map(s -> Pair.of((Object)m, (Object)s))).flatMap(Optional::stream).map(p -> this.validate(node, duration, (WebTemplateComparisonSymbol)p.getRight(), (TemporalAmount)DurationHelper.buildTotalRange((WebTemplateNode)node, (DurationHelper.MIN_MAX)((DurationHelper.MIN_MAX)p.getLeft())).orElse(PeriodDuration.ZERO))).forEach(result::addAll);
        return result;
    }

    private List<ConstraintViolation> validate(WebTemplateNode node, PeriodDuration duration, WebTemplateComparisonSymbol symbol, TemporalAmount range) {
        boolean condition;
        ArrayList<ConstraintViolation> result = new ArrayList<ConstraintViolation>();
        switch (symbol) {
            case GT_EQ: {
                condition = new DvDuration((TemporalAmount)duration).compareTo((DvQuantified)new DvDuration(range)) >= 0;
                break;
            }
            case GT: {
                condition = new DvDuration((TemporalAmount)duration).compareTo((DvQuantified)new DvDuration(range)) > 0;
                break;
            }
            case LT_EQ: {
                condition = new DvDuration((TemporalAmount)duration).compareTo((DvQuantified)new DvDuration(range)) <= 0;
                break;
            }
            case LT: {
                condition = new DvDuration((TemporalAmount)duration).compareTo((DvQuantified)new DvDuration(range)) < 0;
                break;
            }
            default: {
                condition = false;
            }
        }
        if (!condition) {
            result.add(new ConstraintViolation(node.getAqlPath(), String.format("The value %s must be %s %s", duration, symbol.getSymbol(), range)));
        }
        return result;
    }

    private Long getValue(PeriodDuration duration, String unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must not be null");
        }
        switch (unit) {
            case "year": {
                return duration.get((TemporalUnit)ChronoUnit.YEARS);
            }
            case "month": {
                return duration.get((TemporalUnit)ChronoUnit.MONTHS);
            }
            case "day": {
                return duration.get((TemporalUnit)ChronoUnit.DAYS);
            }
            case "week": {
                return duration.get((TemporalUnit)ChronoUnit.DAYS) / 7L;
            }
            case "hour": {
                return duration.getDuration().toHoursPart();
            }
            case "minute": {
                return duration.getDuration().toMinutesPart();
            }
            case "second": {
                return duration.getDuration().toSecondsPart();
            }
        }
        throw new IllegalArgumentException("Unsupported unit: " + unit);
    }

    boolean isNegativ(PeriodDuration periodDuration) {
        return periodDuration.getPeriod().isNegative() || periodDuration.isZero() && periodDuration.getDuration().isNegative();
    }
}

