/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.webtemplate;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.ehrbase.functional.Try;
import org.ehrbase.validation.ConstraintViolation;
import org.ehrbase.validation.ConstraintViolationException;
import org.ehrbase.validation.terminology.ExternalTerminologyValidation;
import org.ehrbase.validation.terminology.TerminologyParam;
import org.ehrbase.validation.webtemplate.ConstraintValidator;
import org.ehrbase.validation.webtemplate.PrimitiveConstraintValidator;
import org.ehrbase.validation.webtemplate.WebTemplateValidationUtils;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.webtemplate.model.WebTemplateNode;

public class DvCodedTextValidator
implements ConstraintValidator<DvCodedText> {
    private final PrimitiveConstraintValidator validator = new PrimitiveConstraintValidator();
    private ExternalTerminologyValidation externalTerminologyValidation;

    public DvCodedTextValidator() {
    }

    public DvCodedTextValidator(ExternalTerminologyValidation externalTerminologyValidation) {
        this.externalTerminologyValidation = externalTerminologyValidation;
    }

    public Class<DvCodedText> getAssociatedClass() {
        return DvCodedText.class;
    }

    @Override
    public List<ConstraintViolation> validate(DvCodedText dvCodedText, WebTemplateNode node) {
        ArrayList<ConstraintViolation> result = new ArrayList<ConstraintViolation>();
        WebTemplateValidationUtils.findInputWithType(node, "CODED_TEXT").ifPresent(input -> result.addAll(this.validateInternalCode(node.getAqlPath(), dvCodedText, (WebTemplateInput)input)));
        WebTemplateValidationUtils.findInputWithType(node, "TEXT").ifPresent(input -> result.addAll(this.validateExternalTerminology(node.getAqlPath(), dvCodedText, (WebTemplateInput)input)));
        return result;
    }

    private List<ConstraintViolation> validateInternalCode(String aqlPath, DvCodedText dvCodedText, WebTemplateInput input) {
        ArrayList<ConstraintViolation> result = new ArrayList<ConstraintViolation>();
        CodePhrase definingCode = dvCodedText.getDefiningCode();
        if (input.getTerminology() != null && !Objects.equals(input.getTerminology(), definingCode.getTerminologyId().getValue())) {
            result.add(new ConstraintViolation(aqlPath, MessageFormat.format("CodePhrase terminology does not match, expected: {0}, found: {1}", input.getTerminology(), definingCode.getTerminologyId().getValue())));
        }
        if (WebTemplateValidationUtils.hasList(input)) {
            Optional<WebTemplateInputValue> matching = input.getList().stream().filter(inputValue -> Objects.equals(inputValue.getValue(), definingCode.getCodeString())).findFirst();
            if (matching.isEmpty()) {
                result.add(new ConstraintViolation(aqlPath, MessageFormat.format("CodePhrase codeString does not match any option, found: {0}", definingCode.getCodeString())));
            } else if (!matching.get().getLabel().equals(dvCodedText.getValue())) {
                result.add(new ConstraintViolation(aqlPath, MessageFormat.format("CodePhrase codeString does not match any option, found: {0}", definingCode.getCodeString())));
            }
        }
        return result;
    }

    private List<ConstraintViolation> validateExternalTerminology(String aqlPath, DvCodedText dvCodedText, WebTemplateInput input) {
        Try<Boolean, ConstraintViolationException> validationResult;
        ArrayList<ConstraintViolation> result = new ArrayList<ConstraintViolation>();
        TerminologyParam tp = TerminologyParam.ofFhir(input.getTerminology());
        tp.setCodePhrase(dvCodedText.getDefiningCode());
        if (this.externalTerminologyValidation != null && this.externalTerminologyValidation.supports(tp) && (validationResult = this.externalTerminologyValidation.validate(tp)).isFailure()) {
            ConstraintViolationException ex = (ConstraintViolationException)validationResult.getAsFailure().get();
            result.add(new ConstraintViolation(aqlPath, "Failed to validate " + dvCodedText.toString()));
            result.addAll(ex.getConstraintViolations());
        }
        return result;
    }
}

