/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.terminology;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minidev.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.ehrbase.functional.Try;
import org.ehrbase.validation.ConstraintViolation;
import org.ehrbase.validation.ConstraintViolationException;
import org.ehrbase.validation.terminology.ExternalTerminologyValidation;
import org.ehrbase.validation.terminology.ExternalTerminologyValidationException;
import org.ehrbase.validation.terminology.TerminologyParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirTerminologyValidation
implements ExternalTerminologyValidation {
    private static final Logger LOG = LoggerFactory.getLogger(FhirTerminologyValidation.class);
    private final String baseUrl;
    private final boolean failOnError;
    private final Executor executor;
    static final String SUPPORTS_CODE_SYS_TEMPL = "%s/CodeSystem?url=%s";
    static final String SUPPORTS_VALUE_SET_TEMPL = "%s/ValueSet?url=%s";
    private static final String ERR_SUPPORTS = "An error occurred while checking if FHIR terminology server supports the referenceSetUri: %s";
    static final String CODE_PHRASE_TEMPL = "code=%s&system=%s";
    private static final String ERR_EXPAND_VALUESET = "Error while expanding ValueSet[%s]";
    static final String EXPAND_VALUE_SET_TEMPL = "%s/ValueSet/$expand?%s";
    private final Set<String> acceptedFhirApis = new HashSet<String>(){
        {
            this.add("//fhir.hl7.org");
            this.add("terminology://fhir.hl7.org");
            this.add("//hl7.org/fhir");
        }

        @Override
        public String toString() {
            return this.stream().collect(Collectors.joining(", "));
        }
    };

    public FhirTerminologyValidation(String baseUrl) {
        this(baseUrl, true);
    }

    public FhirTerminologyValidation(String baseUrl, boolean failOnError) {
        this(baseUrl, failOnError, (HttpClient)HttpClients.createDefault());
    }

    public FhirTerminologyValidation(String baseUrl, boolean failOnError, HttpClient httpClient) {
        this.baseUrl = baseUrl;
        this.failOnError = failOnError;
        this.executor = Executor.newInstance((HttpClient)httpClient);
    }

    private String extractUrl(String referenceSetUri) {
        return StringUtils.substringAfter((String)referenceSetUri, (String)"url=");
    }

    private DocumentContext internalGet(String uri) throws IOException {
        Request request = Request.Get((String)uri).addHeader("Accept", "application/fhir+json");
        HttpResponse response = this.executor.execute(request).returnResponse();
        String responseBody = Optional.ofNullable(response.getEntity()).map(entity -> {
            try {
                return EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                return null;
            }
        }).orElse("");
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new ExternalTerminologyValidationException("Error response received from the terminology server. HTTP status: " + statusCode + ". Body: " + responseBody);
        }
        return JsonPath.parse((String)responseBody);
    }

    static String renderTempl(String templ, String ... args) {
        return String.format(templ, args);
    }

    private boolean isValidTerminology(Optional<String> url) {
        if (url.isEmpty()) {
            return false;
        }
        return this.acceptedFhirApis.stream().filter(api -> ((String)url.get()).startsWith((String)api)).map(api -> Boolean.TRUE).findFirst().orElse(Boolean.FALSE);
    }

    @Override
    public boolean supports(TerminologyParam param) {
        String url = null;
        Optional<String> urlParam = param.extractFromParameter(p -> Optional.ofNullable(this.extractUrl((String)p)));
        if (urlParam.isEmpty() || !this.isValidTerminology(param.getServiceApi())) {
            return false;
        }
        if (param.isUseValueSet()) {
            url = FhirTerminologyValidation.renderTempl(SUPPORTS_VALUE_SET_TEMPL, this.baseUrl, urlParam.get());
        } else if (param.isUseCodeSystem()) {
            url = FhirTerminologyValidation.renderTempl(SUPPORTS_CODE_SYS_TEMPL, this.baseUrl, urlParam.get());
        } else {
            return false;
        }
        try {
            return (Integer)this.internalGet(url).read("$.total", Integer.TYPE, new Predicate[0]) > 0;
        }
        catch (IOException e) {
            if (this.failOnError) {
                throw new ExternalTerminologyValidationException(String.format(ERR_SUPPORTS, url), e);
            }
            LOG.warn("The following error occurred: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public Try<Boolean, ConstraintViolationException> validate(TerminologyParam param) {
        Optional<String> url = param.extractFromParameter(p -> Optional.ofNullable(this.extractUrl((String)p)));
        if (url.isEmpty()) {
            return Try.failure((Exception)new ConstraintViolationException(List.of(new ConstraintViolation("Missing value-set url"))));
        }
        if (param.isUseCodeSystem()) {
            return this.validateCode(url.get(), param.getCodePhrase().get());
        }
        if (param.isUseValueSet()) {
            return this.expandValueSet(url.get(), param.getCodePhrase().get());
        }
        throw new IllegalStateException();
    }

    static String guaranteePrefix(String prefix, String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        if (str.contains(prefix)) {
            return str;
        }
        return prefix + str;
    }

    @Override
    public List<DvCodedText> expand(TerminologyParam param) {
        if (param.getServiceApi().isEmpty() || !this.isValidTerminology(param.getServiceApi())) {
            LOG.warn("Unsupported service-api: {}", param.getServiceApi());
            return Collections.emptyList();
        }
        Optional<String> urlParam = param.extractFromParameter(p -> Optional.ofNullable(FhirTerminologyValidation.guaranteePrefix("url=", p)));
        if (urlParam.isEmpty() || param.getServiceApi().isEmpty() || !this.isValidTerminology(param.getServiceApi())) {
            return Collections.emptyList();
        }
        try {
            DocumentContext jsonContext = this.internalGet(FhirTerminologyValidation.renderTempl(EXPAND_VALUE_SET_TEMPL, this.baseUrl, urlParam.get()));
            return ValueSetConverter.convert(jsonContext);
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new ExternalTerminologyValidationException(String.format(ERR_EXPAND_VALUESET, e));
            }
            LOG.warn(String.format(ERR_EXPAND_VALUESET, e.getMessage()));
            return Collections.emptyList();
        }
    }

    private Try<Boolean, ConstraintViolationException> validateCode(String url, CodePhrase codePhrase) {
        DocumentContext context;
        if (!StringUtils.equals((CharSequence)url, (CharSequence)codePhrase.getTerminologyId().getValue())) {
            ConstraintViolation constraintViolation = new ConstraintViolation(MessageFormat.format("The terminology {0} must be {1}", codePhrase.getTerminologyId().getValue(), url));
            return Try.failure((Exception)new ConstraintViolationException(List.of(constraintViolation)));
        }
        try {
            context = this.internalGet(this.baseUrl + "/CodeSystem/$validate-code?url=" + url + "&code=" + codePhrase.getCodeString());
        }
        catch (IOException e) {
            if (this.failOnError) {
                throw new ExternalTerminologyValidationException("An error occurred while validating the code in CodeSystem", e);
            }
            LOG.warn("An error occurred while validating the code in CodeSystem: {}", (Object)e.getMessage());
            return Try.success((Object)Boolean.FALSE);
        }
        boolean result = (Boolean)context.read("$.parameter[0].valueBoolean", Boolean.TYPE, new Predicate[0]);
        if (!result) {
            String message = (String)context.read("$.parameter[1].valueString", String.class, new Predicate[0]);
            ConstraintViolation constraintViolation = new ConstraintViolation(message);
            return Try.failure((Exception)new ConstraintViolationException(List.of(constraintViolation)));
        }
        return Try.success((Object)Boolean.TRUE);
    }

    private Try<Boolean, ConstraintViolationException> expandValueSet(String url, CodePhrase codePhrase) {
        Map coding;
        DocumentContext context;
        try {
            context = this.internalGet(this.baseUrl + "/ValueSet/$expand?url=" + url);
        }
        catch (IOException e) {
            if (this.failOnError) {
                throw new ExternalTerminologyValidationException("An error occurred while expanding the ValueSet", e);
            }
            LOG.warn("An error occurred while expanding the ValueSet: {}", (Object)e.getMessage());
            return Try.success((Object)Boolean.FALSE);
        }
        List codings = (List)context.read("$.expansion.contains[?(@.code=='" + codePhrase.getCodeString() + "')]", new Predicate[0]);
        if (codings.isEmpty()) {
            ConstraintViolation constraintViolation = new ConstraintViolation(MessageFormat.format("The value {0} does not match any option from value set {1}", codePhrase.getCodeString(), url));
            return Try.failure((Exception)new ConstraintViolationException(List.of(constraintViolation)));
        }
        if (codings.size() == 1 && !StringUtils.equals((CharSequence)((CharSequence)(coding = (Map)codings.get(0)).get("system")), (CharSequence)codePhrase.getTerminologyId().getValue())) {
            ConstraintViolation constraintViolation = new ConstraintViolation(MessageFormat.format("The terminology {0} must be  {1}", codePhrase.getCodeString(), url));
            return Try.failure((Exception)new ConstraintViolationException(List.of(constraintViolation)));
        }
        return Try.success((Object)Boolean.TRUE);
    }

    static abstract class ValueSetConverter {
        private static final String CONTAINS = "$['expansion']['contains'][*]";
        private static final String SYS = "system";
        private static final String CODE = "code";
        private static final String DISP = "display";

        ValueSetConverter() {
        }

        static List<DvCodedText> convert(DocumentContext ctx) throws Exception {
            JSONArray read = (JSONArray)ctx.read(CONTAINS, new Predicate[0]);
            return read.stream().map(e -> (Map)e).map(m -> new DvCodedText((String)m.get(DISP), new CodePhrase(new TerminologyId((String)m.get(SYS)), (String)m.get(CODE)))).collect(Collectors.toList());
        }
    }
}

