/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.terminology.openehr.implementation;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ehrbase.terminology.openehr.TerminologyResourceException;
import org.ehrbase.terminology.openehr.implementation.CodeSet;
import org.ehrbase.terminology.openehr.implementation.Concept;
import org.ehrbase.terminology.openehr.implementation.Group;
import org.ehrbase.terminology.openehr.implementation.TerminologySource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLTerminologySource
implements TerminologySource {
    private List<Group> groupList;
    private List<CodeSet> codeSetList = new ArrayList<CodeSet>();

    public static XMLTerminologySource getInstance(String xmlfilename) throws TerminologyResourceException {
        return new XMLTerminologySource(xmlfilename);
    }

    @Override
    public List<CodeSet> getCodeSets() {
        return this.codeSetList;
    }

    @Override
    public List<Group> getConceptGroups() {
        return this.groupList;
    }

    private XMLTerminologySource(String filename) throws TerminologyResourceException {
        this.groupList = new ArrayList<Group>();
        this.loadTerminologyFromXML(filename);
    }

    private void loadTerminologyFromXML(String filename) throws TerminologyResourceException {
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(filename);){
            if (resourceAsStream == null) {
                throw new TerminologyResourceException("Could not access filename:" + filename);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(resourceAsStream);
            Element root = document.getDocumentElement();
            NodeList codesets = root.getElementsByTagName("codeset");
            this.codeSetList.clear();
            this.groupList.clear();
            for (int idx = 0; idx < codesets.getLength(); ++idx) {
                Element element = (Element)codesets.item(idx);
                this.codeSetList.add(this.loadCodeSet(element));
            }
            NodeList groups = root.getElementsByTagName("group");
            for (int idx = 0; idx < groups.getLength(); ++idx) {
                Element element = (Element)groups.item(idx);
                this.groupList.add(this.loadGroup(element));
            }
        }
        catch (Exception e) {
            throw new TerminologyResourceException(e.getMessage());
        }
    }

    private CodeSet loadCodeSet(Element element) {
        CodeSet codeset = new CodeSet();
        codeset.openehrId = element.getAttribute("openehr_id");
        codeset.issuer = element.getAttribute("issuer");
        codeset.externalId = element.getAttribute("external_id");
        NodeList children = element.getElementsByTagName("code");
        for (int idx = 0; idx < children.getLength(); ++idx) {
            Element code = (Element)children.item(idx);
            codeset.addCode(code.getAttribute("value"), code.getAttribute("description"));
        }
        return codeset;
    }

    private Group loadGroup(Element element) {
        Group group = new Group();
        group.name = element.getAttribute("name");
        NodeList children = element.getElementsByTagName("concept");
        for (int idx = 0; idx < children.getLength(); ++idx) {
            Concept concept = new Concept();
            Element e = (Element)children.item(idx);
            concept.id = e.getAttribute("id");
            concept.rubric = e.getAttribute("rubric");
            group.addConcept(concept);
        }
        return group;
    }
}

