/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.terminology.openehr.implementation;

import org.ehrbase.terminology.openehr.TerminologyResourceException;
import org.ehrbase.terminology.openehr.implementation.TerminologySource;
import org.ehrbase.terminology.openehr.implementation.XMLTerminologySource;

public class TerminologySourceFactory {
    private static final String OPENEHR_TERMINOLOGY_EN = "openehr/en/openehr_terminology.xml";
    private static final String OPENEHR_TERMINOLOGY_JA = "openehr/ja/openehr_terminology.xml";
    private static final String OPENEHR_TERMINOLOGY_PT = "openehr/pt/openehr_terminology.xml";
    private static final String EXTERNAL_TERMINOLOGIES = "openehr_external_terminologies.xml";

    static TerminologySource getOpenEHRTerminology(String language) throws TerminologyResourceException {
        switch (language) {
            case "en": {
                return XMLTerminologySource.getInstance(OPENEHR_TERMINOLOGY_EN);
            }
            case "ja": {
                return XMLTerminologySource.getInstance(OPENEHR_TERMINOLOGY_JA);
            }
            case "pt": {
                return XMLTerminologySource.getInstance(OPENEHR_TERMINOLOGY_PT);
            }
        }
        return XMLTerminologySource.getInstance(OPENEHR_TERMINOLOGY_EN);
    }

    static TerminologySource getOpenEHRTerminology() throws TerminologyResourceException {
        return TerminologySourceFactory.getOpenEHRTerminology("en");
    }

    static TerminologySource getExternalTerminologies(String language) throws TerminologyResourceException {
        return XMLTerminologySource.getInstance(EXTERNAL_TERMINOLOGIES);
    }

    public static TerminologySource getAttributeToGroupMappings() throws TerminologyResourceException {
        return XMLTerminologySource.getInstance(EXTERNAL_TERMINOLOGIES);
    }
}

