/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.terminology.openehr.implementation;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ehrbase.serialisation.util.SnakeCase;
import org.ehrbase.terminology.openehr.TerminologyResourceException;
import org.ehrbase.terminology.openehr.implementation.AttributeGroupMap;
import org.ehrbase.terminology.openehr.implementation.ContainerType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttributeCodesetMapping {
    private Map<String, Map<String, AttributeGroupMap>> groupMaps = new HashMap<String, Map<String, AttributeGroupMap>>();
    private static final String ATTRIBUTE_MAP_DEFINITION = "attribute_to_openehr_codesets.xml";
    private static final String EXTERNAL_ID_PREFIX = "openehr_";

    public static AttributeCodesetMapping getInstance(String xmlfilename) throws TerminologyResourceException {
        return new AttributeCodesetMapping(xmlfilename);
    }

    public static AttributeCodesetMapping getInstance() throws TerminologyResourceException {
        return new AttributeCodesetMapping(ATTRIBUTE_MAP_DEFINITION);
    }

    private Map<String, Map<String, AttributeGroupMap>> getMappers() {
        return this.groupMaps;
    }

    private AttributeCodesetMapping(String filename) throws TerminologyResourceException {
        this.loadMappersFromXML(filename);
    }

    private void loadMappersFromXML(String filename) throws TerminologyResourceException {
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(filename);){
            if (resourceAsStream == null) {
                throw new TerminologyResourceException("Could not access filename:" + filename);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(resourceAsStream);
            Element root = document.getDocumentElement();
            NodeList mapList = root.getElementsByTagName("map");
            for (int idx = 0; idx < mapList.getLength(); ++idx) {
                String terminology;
                Element element = (Element)mapList.item(idx);
                if (element.getElementsByTagName("terminology") != null && element.getElementsByTagName("terminology").getLength() > 0) {
                    terminology = element.getElementsByTagName("terminology").item(0).getTextContent();
                    if (terminology.startsWith(EXTERNAL_ID_PREFIX)) {
                        terminology = "openehr";
                    }
                    if (!this.groupMaps.containsKey(terminology)) {
                        this.groupMaps.put(terminology, new HashMap());
                    }
                } else {
                    throw new IllegalArgumentException("no terminology specified for entry:" + element.toString());
                }
                AttributeGroupMap attributeGroupMap = this.loadMap(element);
                this.groupMaps.get(terminology).put(attributeGroupMap.getAttribute(), attributeGroupMap);
            }
        }
        catch (Exception e) {
            throw new TerminologyResourceException(e.getMessage());
        }
    }

    private AttributeGroupMap loadMap(Element element) {
        String rmAttribute = element.getElementsByTagName("rm_attribute").item(0).getTextContent();
        String container = "";
        if (element.getElementsByTagName("container").getLength() > 0) {
            container = element.getElementsByTagName("container").item(0).getTextContent();
        }
        NodeList matcherList = element.getElementsByTagName("match");
        HashMap<String, String> matcherMap = new HashMap<String, String>();
        for (int idx = 0; idx < matcherList.getLength(); ++idx) {
            Element matcher = (Element)matcherList.item(idx);
            NodeList codeStringMaps = matcher.getElementsByTagName("codeset");
            for (int j = 0; j < codeStringMaps.getLength(); ++j) {
                Element codeStringDef = (Element)codeStringMaps.item(j);
                String language = codeStringDef.getAttribute("language");
                String id = codeStringDef.getAttribute("id");
                matcherMap.put(language, id);
            }
        }
        return new AttributeGroupMap(rmAttribute, container, matcherMap);
    }

    public String actualAttributeId(String terminology, String attribute, String language) {
        if (attribute == null) {
            return null;
        }
        String snakeAttribute = new SnakeCase(attribute).camelToSnake();
        if (!this.getMappers().get(terminology).containsKey(snakeAttribute)) {
            throw new IllegalArgumentException("attribute:" + attribute + ", is not defined in terminology:" + terminology);
        }
        if (!this.getMappers().get(terminology).get(snakeAttribute).getIdMap().containsKey(language)) {
            language = "en";
        }
        return this.getMappers().get(terminology).get(snakeAttribute).getIdMap().get(language);
    }

    public boolean isLocalizedAttribute(String terminology, String attribute, String language) {
        if (attribute == null) {
            return false;
        }
        String snakeAttribute = new SnakeCase(attribute).camelToSnake();
        if (!this.getMappers().containsKey(terminology)) {
            throw new IllegalArgumentException("Invalid terminology id:" + terminology);
        }
        if (!this.getMappers().get(terminology).containsKey(snakeAttribute)) {
            throw new IllegalArgumentException("attribute:" + attribute + ", is not defined in terminology:" + terminology);
        }
        return this.getMappers().get(terminology).get(snakeAttribute).getIdMap().containsKey(language);
    }

    public ContainerType containerType(String terminology, String attribute) {
        if (!this.getMappers().containsKey(terminology)) {
            return ContainerType.UNDEFINED;
        }
        if (!this.getMappers().get(terminology).containsKey(attribute)) {
            if (terminology.equals("openehr")) {
                return ContainerType.GROUP;
            }
            return ContainerType.CODESET;
        }
        return this.getMappers().get(terminology).get(attribute).getContainer();
    }
}

