/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.walker.defaultvalues.defaultinserter;

import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.Participation;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.GenericId;
import java.util.Objects;
import org.ehrbase.client.classgenerator.shareddefinition.Setting;
import org.ehrbase.serialisation.walker.defaultvalues.DefaultValuePath;
import org.ehrbase.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.serialisation.walker.defaultvalues.defaultinserter.AbstractValueInserter;

public class EventContextValueInserter
extends AbstractValueInserter<EventContext> {
    @Override
    public void insert(EventContext rmObject, DefaultValues defaultValues) {
        if (this.isEmpty(rmObject.getStartTime()) && defaultValues.containsDefaultValue(DefaultValuePath.TIME)) {
            rmObject.setStartTime(new DvDateTime(defaultValues.getDefaultValue(DefaultValuePath.TIME)));
        }
        if (this.isEmpty(rmObject.getEndTime()) && defaultValues.containsDefaultValue(DefaultValuePath.END_TIME)) {
            rmObject.setEndTime(new DvDateTime(defaultValues.getDefaultValue(DefaultValuePath.END_TIME)));
        }
        if (this.isEmpty(rmObject.getHealthCareFacility())) {
            rmObject.setHealthCareFacility(this.buildPartyIdentified(defaultValues, DefaultValuePath.HEALTHCARE_FACILITY_NAME, DefaultValuePath.HEALTHCARE_FACILITY_ID, (PartyProxy)rmObject.getHealthCareFacility()));
        }
        if (this.isEmpty(rmObject.getLocation()) && defaultValues.containsDefaultValue(DefaultValuePath.LOCATION)) {
            rmObject.setLocation(defaultValues.getDefaultValue(DefaultValuePath.LOCATION));
        }
        if (this.isEmpty(rmObject.getSetting()) && defaultValues.containsDefaultValue(DefaultValuePath.SETTING)) {
            Setting defaultValue = defaultValues.getDefaultValue(DefaultValuePath.SETTING);
            rmObject.setSetting(new DvCodedText(defaultValue.getValue(), defaultValue.toCodePhrase()));
        }
        if (this.isEmpty(rmObject.getParticipations()) && defaultValues.containsDefaultValue(DefaultValuePath.PARTICIPATION)) {
            rmObject.setParticipations(defaultValues.getDefaultValue(DefaultValuePath.PARTICIPATION));
        }
        if (rmObject.getParticipations() != null) {
            rmObject.getParticipations().stream().map(Participation::getPerformer).filter(Objects::nonNull).map(PartyProxy::getExternalRef).filter(Objects::nonNull).filter(ref -> ref.getId() != null).forEach(ref -> {
                if (ref.getNamespace() == null) {
                    ref.setNamespace(defaultValues.getDefaultValue(DefaultValuePath.ID_NAMESPACE));
                }
                if (ref.getId() instanceof GenericId && ref.getNamespace() == null) {
                    ((GenericId)ref.getId()).setScheme(defaultValues.getDefaultValue(DefaultValuePath.ID_SCHEME));
                }
            });
        }
    }

    public Class<EventContext> getAssociatedClass() {
        return EventContext.class;
    }
}

