/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.walker.defaultvalues;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nedap.archie.datetime.DateTimeParsers;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvEHRURI;
import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.generic.Participation;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.client.classgenerator.EnumValueSet;
import org.ehrbase.client.classgenerator.shareddefinition.ParticipationMode;
import org.ehrbase.client.classgenerator.shareddefinition.State;
import org.ehrbase.serialisation.jsonencoding.JacksonUtil;
import org.ehrbase.serialisation.walker.defaultvalues.DefaultValuePath;
import org.ehrbase.util.exception.SdkException;

public class DefaultValues {
    public static final Collector<Map.Entry<String, String>, ?, Map<String, String>> ATTRIBUTE_COLLECTOR = Collectors.toMap(e -> StringUtils.substringBefore((String)StringUtils.substringAfter((String)((String)e.getKey()), (String)"|"), (String)":"), stringStringEntry -> StringUtils.unwrap((String)((String)stringStringEntry.getValue()), (char)'\"'));
    private final Map<DefaultValuePath, Object> defaultValueMap = new HashMap<DefaultValuePath, Object>();
    private static final ObjectMapper OBJECT_MAPPER = JacksonUtil.getObjectMapper();

    public DefaultValues() {
    }

    public DefaultValues(Map<String, String> flat) {
        Stream.of(DefaultValuePath.LANGUAGE, DefaultValuePath.TERRITORY, DefaultValuePath.COMPOSER_NAME, DefaultValuePath.COMPOSER_ID, DefaultValuePath.ID_SCHEME, DefaultValuePath.ID_NAMESPACE, DefaultValuePath.COMPOSER_SELF, DefaultValuePath.TIME, DefaultValuePath.END_TIME, DefaultValuePath.HISTORY_ORIGIN, DefaultValuePath.ACTION_TIME, DefaultValuePath.ACTIVITY_TIMING, DefaultValuePath.PROVIDER_ID, DefaultValuePath.PROVIDER_NAME, DefaultValuePath.HEALTHCARE_FACILITY_NAME, DefaultValuePath.HEALTHCARE_FACILITY_ID, DefaultValuePath.ACTION_ISM_TRANSITION_CURRENT_STATE, DefaultValuePath.INSTRUCTION_NARRATIVE, DefaultValuePath.LOCATION, DefaultValuePath.SETTING, DefaultValuePath.PARTICIPATION, DefaultValuePath.WORKFLOW_ID, DefaultValuePath.LINKS).forEach(path -> {
            Map<String, String> subValues = this.filter(flat, path.getPath());
            if (!subValues.isEmpty()) {
                if (EnumValueSet.class.isAssignableFrom(path.getType())) {
                    String value = subValues.values().stream().map(DefaultValues::read).findAny().orElseThrow();
                    this.defaultValueMap.put((DefaultValuePath)path, this.findEnumValue(value, path.getType()));
                } else if (String.class.isAssignableFrom(path.getType())) {
                    String value = subValues.values().stream().map(DefaultValues::read).findAny().orElseThrow();
                    this.defaultValueMap.put((DefaultValuePath)path, value);
                } else if (Boolean.class.isAssignableFrom(path.getType())) {
                    String value = subValues.values().stream().map(DefaultValues::read).findAny().orElseThrow();
                    if (value.equals("true")) {
                        this.defaultValueMap.put((DefaultValuePath)path, value);
                    }
                } else if (TemporalAccessor.class.isAssignableFrom(path.getType())) {
                    String value = subValues.values().stream().map(DefaultValues::read).findAny().orElseThrow();
                    this.defaultValueMap.put((DefaultValuePath)path, DateTimeParsers.parseDateTimeValue((String)value));
                } else if (path.equals(DefaultValuePath.PARTICIPATION)) {
                    Map<Integer, List<Map.Entry>> byIndex = subValues.entrySet().stream().collect(Collectors.groupingBy(e -> {
                        String s = StringUtils.substringBefore((String)StringUtils.substringAfter((String)((String)e.getKey()), (String)":"), (String)"|");
                        return StringUtils.isBlank((CharSequence)s) ? 0 : Integer.parseInt(s);
                    }));
                    ArrayList participations = new ArrayList();
                    byIndex.values().stream().map(this::buildParticipation).forEach(participations::add);
                    this.defaultValueMap.put((DefaultValuePath)path, participations);
                } else if (path.equals(DefaultValuePath.WORKFLOW_ID)) {
                    ObjectRef ref = new ObjectRef();
                    Map<String, String> attributes = subValues.entrySet().stream().collect(ATTRIBUTE_COLLECTOR);
                    ref.setNamespace(attributes.get("id_namespace"));
                    ref.setType(attributes.get("id_type"));
                    ref.setId((ObjectId)new GenericId());
                    ((GenericId)ref.getId()).setValue(attributes.get("id"));
                    ((GenericId)ref.getId()).setScheme(attributes.get("id_scheme"));
                    this.defaultValueMap.put((DefaultValuePath)path, ref);
                } else if (path.equals(DefaultValuePath.LINKS)) {
                    Map<Integer, Map<String, String>> links = subValues.entrySet().stream().collect(Collectors.groupingBy(e -> {
                        String s = StringUtils.substringBefore((String)StringUtils.substringAfter((String)((String)e.getKey()), (String)":"), (String)"|");
                        return StringUtils.isBlank((CharSequence)s) ? 0 : Integer.parseInt(s);
                    }, ATTRIBUTE_COLLECTOR));
                    this.defaultValueMap.put((DefaultValuePath)path, links.values().stream().map(DefaultValues::createLink).collect(Collectors.toList()));
                }
            }
            this.setFlatDefaults();
        });
    }

    private void setFlatDefaults() {
        if (this.defaultValueMap.containsKey(DefaultValuePath.PARTICIPATION)) {
            this.getDefaultValue(DefaultValuePath.PARTICIPATION).stream().map(Participation::getPerformer).map(PartyProxy::getExternalRef).filter(Objects::nonNull).filter(ref -> ref.getId() != null).forEach(ref -> {
                ref.setNamespace(this.getDefaultValue(DefaultValuePath.ID_NAMESPACE));
                ((GenericId)ref.getId()).setScheme(this.getDefaultValue(DefaultValuePath.ID_SCHEME));
            });
        }
        if (this.defaultValueMap.containsKey(DefaultValuePath.WORKFLOW_ID)) {
            if (((GenericId)this.getDefaultValue(DefaultValuePath.WORKFLOW_ID).getId()).getScheme() == null) {
                ((GenericId)this.getDefaultValue(DefaultValuePath.WORKFLOW_ID).getId()).setScheme(this.getDefaultValue(DefaultValuePath.ID_SCHEME));
            }
            if (this.getDefaultValue(DefaultValuePath.WORKFLOW_ID).getNamespace() == null) {
                this.getDefaultValue(DefaultValuePath.WORKFLOW_ID).setNamespace(this.getDefaultValue(DefaultValuePath.ID_NAMESPACE));
            }
        }
        if (!this.defaultValueMap.containsKey(DefaultValuePath.TIME)) {
            this.defaultValueMap.put(DefaultValuePath.TIME, OffsetDateTime.now());
        }
        if (!this.defaultValueMap.containsKey(DefaultValuePath.ACTION_ISM_TRANSITION_CURRENT_STATE)) {
            this.defaultValueMap.put(DefaultValuePath.ACTION_ISM_TRANSITION_CURRENT_STATE, State.INITIAL);
        }
    }

    public static Link createLink(Map<String, String> stringStringMap) {
        Link link = new Link();
        if (stringStringMap.containsKey("meaning")) {
            link.setMeaning(new DvText(stringStringMap.get("meaning")));
        }
        if (stringStringMap.containsKey("type")) {
            link.setType(new DvText(stringStringMap.get("type")));
        }
        if (stringStringMap.containsKey("target")) {
            link.setTarget(new DvEHRURI(stringStringMap.get("target")));
        }
        return link;
    }

    private Map<String, String> filter(Map<String, String> flat, String path) {
        return flat.entrySet().stream().filter(e -> StringUtils.startsWith((CharSequence)((CharSequence)e.getKey()), (CharSequence)("ctx/" + path))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Participation buildParticipation(List<Map.Entry<String, String>> subValues) {
        Participation participation = new Participation();
        participation.setPerformer((PartyProxy)new PartyIdentified());
        this.extract(subValues, "id", s -> {
            participation.getPerformer().setExternalRef(new PartyRef());
            GenericId id = new GenericId();
            id.setValue(s);
            participation.getPerformer().getExternalRef().setId((ObjectId)id);
        });
        this.extract(subValues, "name", arg_0 -> ((PartyIdentified)((PartyIdentified)participation.getPerformer())).setName(arg_0));
        this.extract(subValues, "function", s -> participation.setFunction(new DvText(s)));
        this.extract(subValues, "mode", s -> {
            ParticipationMode participationMode = this.findEnumValue((String)s, (Class)ParticipationMode.class);
            participation.setMode(new DvCodedText());
            participation.getMode().setValue(participationMode.getValue());
            participation.getMode().setDefiningCode(participationMode.toCodePhrase());
        });
        ((PartyIdentified)participation.getPerformer()).setIdentifiers(this.splitByIndex(this.filter(subValues.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), DefaultValuePath.PARTICIPATION.getPath() + "_identifiers")).values().stream().map(this::toDvIdentifier).collect(Collectors.toList()));
        return participation;
    }

    private DvIdentifier toDvIdentifier(Map<String, String> valueMap) {
        DvIdentifier dvIdentifier = new DvIdentifier();
        dvIdentifier.setId(valueMap.get("id"));
        dvIdentifier.setAssigner(valueMap.get("assigner"));
        dvIdentifier.setIssuer(valueMap.get("issuer"));
        dvIdentifier.setType(valueMap.get("type"));
        return dvIdentifier;
    }

    private Map<Integer, Map<String, String>> splitByIndex(Map<String, String> values) {
        Map<Object, Object> map;
        if (values.size() == 1) {
            map = new HashMap();
            String ids = StringUtils.unwrap((String)values.values().stream().findAny().orElseThrow(), (char)'\"');
            int i = 0;
            for (String sub : ids.split(";")) {
                map.put(i, new HashMap());
                String[] split = sub.split("::");
                ((Map)map.get(i)).put("issuer", split[0]);
                ((Map)map.get(i)).put("assigner", split[1]);
                ((Map)map.get(i)).put("id", split[2]);
                ((Map)map.get(i)).put("type", split[3]);
                ++i;
            }
        } else {
            map = values.size() > 1 ? values.entrySet().stream().collect(Collectors.groupingBy(e -> {
                String s = StringUtils.substringAfter((String)StringUtils.substringAfter((String)((String)e.getKey()), (String)"|"), (String)":");
                return StringUtils.isBlank((CharSequence)s) ? 0 : Integer.parseInt(s);
            }, ATTRIBUTE_COLLECTOR)) : Collections.emptyMap();
        }
        return map;
    }

    private void extract(Collection<Map.Entry<String, String>> subValues, String subPath, Consumer<String> stringConsumer) {
        this.filter(subValues.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), DefaultValuePath.PARTICIPATION.getPath() + "_" + subPath).values().stream().map(DefaultValues::read).findAny().ifPresent(stringConsumer);
    }

    private <E extends EnumValueSet> E findEnumValue(String value, Class<E> clazz) {
        return (E)Arrays.stream((EnumValueSet[])clazz.getEnumConstants()).filter(e -> e.getCode().equals(value) || e.getValue().equals(value)).findAny().orElseThrow(() -> new SdkException(String.format("Unknown Value %s in terminology %s", value, ((EnumValueSet[])clazz.getEnumConstants())[0].getTerminologyId())));
    }

    private static String read(String s) {
        try {
            return (String)OBJECT_MAPPER.readValue(s, String.class);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new SdkException(jsonProcessingException.getMessage());
        }
    }

    public <T> void addDefaultValue(DefaultValuePath<T> path, T value) {
        if (value == null) {
            this.defaultValueMap.remove(path);
        } else if (path.getType().isAssignableFrom(value.getClass())) {
            this.defaultValueMap.put(path, value);
        } else {
            throw new SdkException(String.format("Can not set %s can not cast %s to %s", path, path.getType().getSimpleName(), value.getClass().getSimpleName()));
        }
    }

    public void removeDefaultValue(DefaultValuePath path) {
        this.defaultValueMap.remove(path);
    }

    public <T> T getDefaultValue(DefaultValuePath<T> path) {
        return (T)this.defaultValueMap.get(path);
    }

    public boolean containsDefaultValue(DefaultValuePath<?> path) {
        return this.defaultValueMap.containsKey(path);
    }
}

