/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.jsonencoding;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nedap.archie.base.OpenEHRBase;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.archetyped.TemplateId;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.support.identification.ArchetypeID;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import com.nedap.archie.rminfo.ArchieAOMInfoLookup;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.ehrbase.serialisation.RMDataFormat;
import org.ehrbase.serialisation.exception.MarshalException;
import org.ehrbase.serialisation.exception.UnmarshalException;
import org.ehrbase.serialisation.jsonencoding.JacksonUtil;

public class CanonicalJson
implements RMDataFormat {
    @Override
    public String marshal(RMObject rmObject) {
        StringWriter stringWriter = new StringWriter();
        try {
            ObjectMapper om = JacksonUtil.getObjectMapper();
            om.addMixInAnnotations(ArchetypeID.class, ObjectIdMixIn.class);
            om.addMixInAnnotations(Locatable.class, LocatableMixIn.class);
            om.addMixInAnnotations(Pathable.class, PathableMixIn.class);
            om.addMixInAnnotations(UIDBasedId.class, UIDBasedIdMixIn.class);
            om.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            StdTypeResolverBuilder typeResolverBuilder = new CJArchieTypeResolverBuilder().init(JsonTypeInfo.Id.NAME, (TypeIdResolver)new CJOpenEHRTypeNaming()).typeProperty("_type").typeIdVisibility(true).inclusion(JsonTypeInfo.As.PROPERTY);
            om.setDefaultTyping((TypeResolverBuilder)typeResolverBuilder);
            om.writeValue((Writer)stringWriter, (Object)rmObject);
        }
        catch (IOException e) {
            throw new MarshalException(e.getMessage(), e);
        }
        return stringWriter.toString();
    }

    @Override
    public <T extends RMObject> T unmarshal(String value, Class<T> clazz) {
        try {
            return (T)((RMObject)JacksonUtil.getObjectMapper().readValue(value, clazz));
        }
        catch (IOException e) {
            throw new UnmarshalException(e.getMessage(), e);
        }
    }

    public Map<String, Object> unmarshalToMap(String value) {
        try {
            return (Map)JacksonUtil.getObjectMapper().readValue(value, Map.class);
        }
        catch (IOException e) {
            throw new UnmarshalException(e.getMessage(), e);
        }
    }

    public class CJOpenEHRTypeNaming
    extends ClassNameIdResolver {
        private ModelInfoLookup rmInfoLookup;
        private ModelInfoLookup aomInfoLookup;

        public CJOpenEHRTypeNaming() {
            super(TypeFactory.defaultInstance().constructType(OpenEHRBase.class), TypeFactory.defaultInstance());
            this.rmInfoLookup = ArchieRMInfoLookup.getInstance();
            this.aomInfoLookup = ArchieAOMInfoLookup.getInstance();
        }

        public JsonTypeInfo.Id getMechanism() {
            return JsonTypeInfo.Id.NAME;
        }

        public String idFromValue(Object value) {
            RMTypeInfo typeInfo = this.rmInfoLookup.getTypeInfo(value.getClass());
            if (typeInfo == null) {
                typeInfo = this.aomInfoLookup.getTypeInfo(value.getClass());
            }
            if (typeInfo != null) {
                return typeInfo.getRmName();
            }
            return this.rmInfoLookup.getNamingStrategy().getTypeName(value.getClass());
        }

        public JavaType typeFromId(DatabindContext context, String id) throws IOException {
            return this._typeFromId(id, context);
        }

        protected JavaType _typeFromId(String typeName, DatabindContext ctxt) throws IOException {
            Class result = this.rmInfoLookup.getClass(typeName);
            if (result == null) {
                result = this.aomInfoLookup.getClass(typeName);
            }
            if (result != null) {
                TypeFactory typeFactory = ctxt == null ? this._typeFactory : ctxt.getTypeFactory();
                return typeFactory.constructSpecializedType(this._baseType, result);
            }
            return super._typeFromId(typeName, ctxt);
        }
    }

    static class CJArchieTypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        public CJArchieTypeResolverBuilder() {
            super(ObjectMapper.DefaultTyping.NON_FINAL);
        }

        public boolean useForType(JavaType t) {
            return OpenEHRBase.class.isAssignableFrom(t.getRawClass()) && !ArchetypeID.class.equals((Object)t.getRawClass()) && !TemplateId.class.equals((Object)t.getRawClass()) && !Archetyped.class.equals((Object)t.getRawClass()) && !Link.class.equals((Object)t.getRawClass()) && !History.class.equals((Object)t.getRawClass());
        }
    }

    abstract class PathableMixIn {
        PathableMixIn() {
        }

        @JsonIgnore
        abstract String getPath();

        @JsonIgnore
        abstract List<PathSegment> getPathSegments();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    abstract class LocatableMixIn {
        LocatableMixIn(@JsonProperty UIDBasedId uid, @JsonProperty String archetypeNodeId, List<Link> links) {
        }

        @JsonProperty(value="archetype_node_id")
        abstract String getArchetypeNodeId();

        @JsonProperty(value="uid")
        abstract UIDBasedId getUid();

        @JsonProperty(value="links")
        abstract List<Link> getLinks();
    }

    abstract class UIDBasedIdMixIn {
        UIDBasedIdMixIn(String value) {
        }

        @JsonProperty(value="value")
        abstract String getValue();

        @JsonIgnore
        abstract String getRoot();

        @JsonIgnore
        abstract String getExtension();
    }

    abstract class ObjectIdMixIn {
        ObjectIdMixIn(String value) {
        }

        @JsonProperty(value="value")
        abstract String getValue();

        @JsonIgnore
        abstract String getFullId();

        @JsonIgnore
        abstract String getSemanticId();

        @JsonIgnore
        abstract String getQualifiedRmEntity();

        @JsonIgnore
        abstract String getDomainConcept();

        @JsonIgnore
        abstract String getRmOriginator();

        @JsonIgnore
        abstract String getRmName();

        @JsonIgnore
        abstract String getRmEntity();

        @JsonIgnore
        abstract String getSpecialisation();

        @JsonIgnore
        abstract String getVersionId();
    }
}

