/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.flatencoding.std.umarshal.rmunmarshaller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nedap.archie.rm.RMObject;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.serialisation.flatencoding.std.umarshal.rmunmarshaller.RMUnmarshaller;
import org.ehrbase.serialisation.jsonencoding.JacksonUtil;
import org.ehrbase.serialisation.walker.Context;
import org.ehrbase.util.exception.SdkException;
import org.ehrbase.util.reflection.ReflectionHelper;
import org.ehrbase.webtemplate.parser.config.RmIntrospectConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRMUnmarshaller<T extends RMObject>
implements RMUnmarshaller<T> {
    private static final ObjectMapper OBJECT_MAPPER = JacksonUtil.getObjectMapper();
    private static final Map<Class<?>, RmIntrospectConfig> configMap = ReflectionHelper.buildMap(RmIntrospectConfig.class);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Set<String> consumedPath = new HashSet<String>();

    @Override
    public void handle(String currentTerm, T rmObject, Map<String, String> currentValues, Context<Map<String, String>> context) {
        Set expandFields = Optional.ofNullable(configMap.get(rmObject.getClass())).map(RmIntrospectConfig::getNonTemplateFields).orElse(Collections.emptySet());
        if (!expandFields.isEmpty()) {
            if (expandFields.size() == 1 && expandFields.contains("value")) {
                try {
                    PropertyDescriptor propertyDescriptor = new PropertyDescriptor("value", rmObject.getClass());
                    this.setValue(currentTerm, null, currentValues, s -> {
                        try {
                            propertyDescriptor.getWriteMethod().invoke(rmObject, s);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new SdkException(e.getMessage(), (Throwable)e);
                        }
                    }, propertyDescriptor.getPropertyType());
                }
                catch (IntrospectionException e) {
                    throw new SdkException(e.getMessage(), (Throwable)e);
                }
            } else {
                for (String propertyName : expandFields) {
                    try {
                        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(propertyName, rmObject.getClass());
                        this.setValue(currentTerm, propertyName, currentValues, s -> {
                            try {
                                propertyDescriptor.getWriteMethod().invoke(rmObject, s);
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                throw new SdkException(e.getMessage(), (Throwable)e);
                            }
                        }, propertyDescriptor.getPropertyType());
                    }
                    catch (IntrospectionException e) {
                        throw new SdkException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected <S> void setValue(String term, String propertyName, Map<String, String> values, Consumer<S> consumer, Class<S> clazz) {
        Object key = propertyName != null ? term + "|" + propertyName : term;
        String jasonValue = values.get(key);
        if (StringUtils.isNotBlank((CharSequence)jasonValue)) {
            try {
                Object value = OBJECT_MAPPER.readValue(jasonValue, clazz);
                consumer.accept(value);
                this.consumedPath.add((String)key);
            }
            catch (JsonProcessingException e) {
                this.log.error(e.getMessage());
            }
        } else {
            consumer.accept(null);
            this.consumedPath.add((String)key);
        }
    }

    @Override
    public Set<String> getConsumedPaths() {
        return this.consumedPath;
    }
}

