/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.flatencoding.std.umarshal.postprocessor;

import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.PartyIdentified;
import java.util.Map;
import java.util.stream.Collectors;
import org.ehrbase.serialisation.flatencoding.std.umarshal.postprocessor.AbstractUnmarshalPostprocessor;
import org.ehrbase.serialisation.flatencoding.std.umarshal.rmunmarshaller.PartyIdentifiedRMUnmarshaller;
import org.ehrbase.serialisation.walker.Context;

public class EventContextUnmarshalPostprocessor
extends AbstractUnmarshalPostprocessor<EventContext> {
    private static final PartyIdentifiedRMUnmarshaller PARTY_IDENTIFIED_RM_UNMARSHALLER = new PartyIdentifiedRMUnmarshaller();

    @Override
    public void process(String term, EventContext rmObject, Map<String, String> values) {
        this.setValue(term + "/_end_time", null, values, s -> {
            if (s != null) {
                rmObject.setEndTime(new DvDateTime(s));
            }
        }, String.class);
        Map<String, String> health_care_facilityValues = values.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(term + "/_health_care_facility")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!health_care_facilityValues.isEmpty()) {
            rmObject.setHealthCareFacility(new PartyIdentified());
            PARTY_IDENTIFIED_RM_UNMARSHALLER.handle(term + "/_health_care_facility", rmObject.getHealthCareFacility(), health_care_facilityValues, (Context<Map<String, String>>)null);
        }
    }

    public Class<EventContext> getAssociatedClass() {
        return EventContext.class;
    }
}

