/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.flatencoding.std.umarshal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nedap.archie.rm.composition.Composition;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ehrbase.building.OptSkeletonBuilder;
import org.ehrbase.client.classgenerator.shareddefinition.Setting;
import org.ehrbase.normalizer.Normalizer;
import org.ehrbase.serialisation.exception.UnmarshalException;
import org.ehrbase.serialisation.flatencoding.std.umarshal.StdToCompositionWalker;
import org.ehrbase.serialisation.jsonencoding.JacksonUtil;
import org.ehrbase.serialisation.walker.defaultvalues.DefaultValuePath;
import org.ehrbase.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;

public class FlatJsonUnmarshaller {
    private static final ObjectMapper OBJECT_MAPPER = JacksonUtil.getObjectMapper();
    public static final OptSkeletonBuilder OPT_SKELETON_BUILDER = new OptSkeletonBuilder();
    public static final Normalizer NORMALIZER = new Normalizer();
    private Set<String> consumedPath;
    private Map<String, String> currentValues;

    public Composition unmarshal(String flat, WebTemplate introspect, OPERATIONALTEMPLATE operationalTemplate) {
        this.consumedPath = new HashSet<String>();
        try {
            this.currentValues = new HashMap<String, String>();
            Iterator it = OBJECT_MAPPER.readTree(flat).fields();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                this.currentValues.put((String)e.getKey(), ((JsonNode)e.getValue()).toString());
            }
            Composition generate = (Composition)OPT_SKELETON_BUILDER.generate(operationalTemplate);
            StdToCompositionWalker walker = new StdToCompositionWalker();
            DefaultValues defaultValues = new DefaultValues(this.currentValues);
            if (!defaultValues.containsDefaultValue(DefaultValuePath.TIME)) {
                defaultValues.addDefaultValue(DefaultValuePath.TIME, OffsetDateTime.now());
            }
            if (!defaultValues.containsDefaultValue(DefaultValuePath.SETTING)) {
                defaultValues.addDefaultValue(DefaultValuePath.SETTING, Setting.OTHER_CARE);
            }
            walker.walk(generate, this.currentValues, introspect, defaultValues);
            this.consumedPath = walker.getConsumedPaths();
            return (Composition)NORMALIZER.normalize((Object)generate);
        }
        catch (JsonProcessingException e) {
            throw new UnmarshalException(e.getMessage(), e);
        }
    }

    public Set<String> getUnconsumed() {
        if (this.currentValues != null && this.consumedPath != null) {
            HashSet<String> set = new HashSet<String>(this.currentValues.keySet());
            set.removeAll(this.consumedPath);
            return set;
        }
        return Collections.emptySet();
    }
}

