/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.flatencoding.std.marshal.config;

import com.nedap.archie.rm.RMObject;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.serialisation.flatencoding.std.marshal.config.StdConfig;
import org.ehrbase.serialisation.walker.Context;
import org.ehrbase.util.exception.SdkException;
import org.ehrbase.util.reflection.ReflectionHelper;
import org.ehrbase.webtemplate.parser.config.RmIntrospectConfig;

public abstract class AbstractsStdConfig<T extends RMObject>
implements StdConfig<T> {
    private static final Map<Class<?>, RmIntrospectConfig> configMap = ReflectionHelper.buildMap(RmIntrospectConfig.class);

    @Override
    public Map<String, Object> buildChildValues(String currentTerm, T rmObject, Context<Map<String, Object>> context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set expandFields = Optional.ofNullable(configMap.get(rmObject.getClass())).map(RmIntrospectConfig::getNonTemplateFields).orElse(Collections.emptySet());
        if (!expandFields.isEmpty()) {
            if (expandFields.size() == 1 && expandFields.contains("value")) {
                try {
                    PropertyDescriptor propertyDescriptor = new PropertyDescriptor("value", rmObject.getClass());
                    Object property = propertyDescriptor.getReadMethod().invoke(rmObject, new Object[0]);
                    result.put(currentTerm, property);
                }
                catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                    throw new SdkException(e.getMessage(), (Throwable)e);
                }
            } else {
                for (String propertyName : expandFields) {
                    try {
                        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(propertyName, rmObject.getClass());
                        Object property = propertyDescriptor.getReadMethod().invoke(rmObject, new Object[0]);
                        result.put(currentTerm + "|" + propertyName, property);
                    }
                    catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                        throw new SdkException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            result.put(currentTerm, rmObject);
        }
        return result;
    }

    protected void addValue(Map<String, Object> result, String termLoop, String propertyName, Object value) {
        if (value != null) {
            Object key = StringUtils.isNotBlank((CharSequence)propertyName) ? termLoop + "|" + propertyName : termLoop;
            result.put((String)key, value);
        }
    }
}

