/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.flatencoding.std.marshal;

import com.nedap.archie.rm.RMObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.ehrbase.serialisation.flatencoding.std.marshal.config.DefaultStdConfig;
import org.ehrbase.serialisation.flatencoding.std.marshal.config.StdConfig;
import org.ehrbase.serialisation.flatencoding.std.marshal.postprocessor.MarshalPostprocessor;
import org.ehrbase.serialisation.walker.Context;
import org.ehrbase.serialisation.walker.FromCompositionWalker;
import org.ehrbase.util.reflection.ReflectionHelper;
import org.ehrbase.webtemplate.model.WebTemplateNode;

public class StdFromCompositionWalker
extends FromCompositionWalker<Map<String, Object>> {
    private static final Map<Class<? extends RMObject>, StdConfig> configMap = ReflectionHelper.buildMap(StdConfig.class);
    private static final Map<Class<? extends RMObject>, MarshalPostprocessor> POSTPROCESSOR_MAP = ReflectionHelper.buildMap(MarshalPostprocessor.class);
    public static final DefaultStdConfig DEFAULT_STD_CONFIG = new DefaultStdConfig();

    @Override
    protected Map<String, Object> extract(Context<Map<String, Object>> context, WebTemplateNode child, boolean isChoice, Integer i) {
        return context.getObjectDeque().peek();
    }

    @Override
    protected void preHandle(Context<Map<String, Object>> context) {
        if (!this.visitChildren(context.getNodeDeque().peek())) {
            RMObject currentObject = context.getRmObjectDeque().peek();
            StdConfig stdConfig = configMap.getOrDefault(currentObject.getClass(), DEFAULT_STD_CONFIG);
            context.getObjectDeque().peek().putAll(stdConfig.buildChildValues(this.buildNamePath(context, true), currentObject, context));
        }
    }

    @Override
    protected void postHandle(Context<Map<String, Object>> context) {
        ArrayList<MarshalPostprocessor> postprocessor = new ArrayList<MarshalPostprocessor>();
        for (Class<?> currentClass = context.getRmObjectDeque().peek().getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            if (!POSTPROCESSOR_MAP.containsKey(currentClass)) continue;
            postprocessor.add(POSTPROCESSOR_MAP.get(currentClass));
        }
        Collections.reverse(postprocessor);
        postprocessor.forEach(p -> p.process(this.buildNamePath(context, true), context.getRmObjectDeque().peek(), (Map)context.getObjectDeque().peek()));
    }
}

