/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.dbencoding.rmobject;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import java.util.Map;
import org.ehrbase.serialisation.dbencoding.EncodeUtilArchie;
import org.ehrbase.serialisation.dbencoding.rawjson.LightRawJsonEncoder;
import org.ehrbase.serialisation.jsonencoding.CanonicalJson;

public abstract class RMObjectEncoding {
    protected String toDB(Map<String, Object> objectMap) {
        GsonBuilder builder = EncodeUtilArchie.getGsonBuilderInstance();
        Gson gson = builder.setPrettyPrinting().create();
        return gson.toJson(objectMap);
    }

    protected RMObject fromDB(String rmClassName, String dbJonRepresentation) {
        Class clazz = ArchieRMInfoLookup.getInstance().getClass(rmClassName);
        return this.fromDB(clazz, dbJonRepresentation);
    }

    protected RMObject fromDB(Class clazz, String dbJonRepresentation) {
        JsonElement interpreted = new LightRawJsonEncoder(dbJonRepresentation).encodeContentAsJson(null);
        return new CanonicalJson().unmarshal(interpreted.toString(), clazz);
    }
}

