/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.dbencoding;

import java.util.Map;
import org.ehrbase.serialisation.dbencoding.CompositionSerializer;
import org.ehrbase.serialisation.dbencoding.ItemStack;
import org.ehrbase.serialisation.dbencoding.SerialTree;

public class PathItem {
    private Map<String, Object> map;
    private final CompositionSerializer.WalkerOutputMode tagMode;
    private final ItemStack itemStack;

    public PathItem(Map<String, Object> map, CompositionSerializer.WalkerOutputMode tagMode, ItemStack itemStack) {
        this.map = map;
        this.tagMode = tagMode;
        this.itemStack = itemStack;
    }

    public Map<String, Object> encode(String tag) {
        Map<String, Object> retMap = this.map;
        switch (this.tagMode) {
            case PATH: {
                retMap = new SerialTree(this.map).insert(null, null, "/$PATH$", tag == null ? this.itemStack.pathStackDump() : this.itemStack.pathStackDump() + tag);
                break;
            }
            case NAMED: {
                retMap = new SerialTree(this.map).insert(null, null, "/$PATH$", tag == null ? this.itemStack.namedStackDump() : this.itemStack.namedStackDump() + tag.substring(1));
                break;
            }
            case EXPANDED: {
                retMap = new SerialTree(this.map).insert(null, null, "/$PATH$", tag == null ? this.itemStack.expandedStackDump() : this.itemStack.expandedStackDump() + tag.substring(1));
                break;
            }
            case RAW: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tagging mode!");
            }
        }
        return retMap;
    }
}

