/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.dbencoding;

import com.nedap.archie.rm.archetyped.Locatable;
import org.apache.commons.collections.map.MultiValueMap;
import org.ehrbase.serialisation.dbencoding.CompositionSerializer;

public class NodeEncoding {
    private final CompositionSerializer.WalkerOutputMode tagMode;

    public NodeEncoding(CompositionSerializer.WalkerOutputMode tagMode) {
        this.tagMode = tagMode;
    }

    public String tag(String prefix, Locatable node, Object container) {
        switch (this.tagMode) {
            case PATH: {
                String name;
                if (node == null) {
                    return prefix;
                }
                String path = prefix + "[" + node.getArchetypeNodeId() + "]";
                if (!container.getClass().equals(MultiValueMap.class) && !path.startsWith("/description") && !path.startsWith("/composition") && (path.contains("[openEHR-") || path.contains("/activities") || path.contains("/items") || path.contains("/events")) && (name = node.getName().getValue()) != null) {
                    path = path.substring(0, path.lastIndexOf("]")) + " and name/value='" + name + "']";
                }
                return path;
            }
            case NAMED: 
            case EXPANDED: 
            case RAW: {
                if (prefix.equals("/origin") || prefix.equals("/time") || prefix.equals("/timing") || prefix.equals("/events") && node == null) {
                    return "[" + prefix.substring(1) + "]";
                }
                if (node == null) {
                    return "!!!INVALID NAMED for " + prefix + " !!!";
                }
                return node.getArchetypeNodeId();
            }
        }
        return "*INVALID MODE*";
    }
}

