/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.dbencoding;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemStack {
    private static final String archetypePrefix = "[openEHR-";
    private static final String namedItemPrefix = " and name/value='";
    private static final String namedItemSuffix = "']";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Deque<String> pathStack = new ArrayDeque<String>();
    private Deque<String> namedStack = new ArrayDeque<String>();
    private Stack<ContainmentStruct> containmentStack = new Stack();
    private Map<String, String> ltreeMap = new TreeMap<String, String>();

    public Map<String, String> getLtreeMap() {
        return this.ltreeMap;
    }

    public static String normalizeLabel(String path) {
        String label = path.substring(path.indexOf("[") + 1);
        int namedIndex = label.indexOf(namedItemPrefix);
        if (namedIndex >= 0) {
            label = label.substring(0, namedIndex);
        }
        if ((label = label.replace("\\.", "_").replace("-", "_")).endsWith("]")) {
            label = label.substring(0, label.indexOf("]"));
        }
        return label;
    }

    public static String getLabelType(String path) {
        if (path.contains("[")) {
            return path.substring(1, path.indexOf("["));
        }
        return path;
    }

    private boolean isArchetypeSlot(String path) {
        return path.contains(archetypePrefix);
    }

    private void flushContainmentMap() {
        ContainmentStruct containmentStruct = (ContainmentStruct)this.containmentStack.lastElement();
        if (!this.ltreeMap.containsKey(containmentStruct.getLabel())) {
            this.ltreeMap.put(containmentStruct.getLabel(), containmentStruct.getFullPath());
        }
    }

    public void pushStacks(String path, String name) {
        this.log.debug("-- PUSH PATH:" + (String)path + "::" + name);
        if ((((String)path).contains(archetypePrefix) || ((String)path).contains("/activities") || ((String)path).contains("/items") || ((String)path).contains("/events")) && name != null) {
            path = ((String)path).substring(0, ((String)path).indexOf("]")) + namedItemPrefix + name + namedItemSuffix;
        }
        this.pushStack(this.pathStack, (String)path);
        if (name != null) {
            this.pushStack(this.namedStack, name.toLowerCase().replace(" ", "_"));
        }
        if (this.isArchetypeSlot((String)path)) {
            Object label = ItemStack.normalizeLabel((String)path);
            String previousLabel = null;
            if (!this.containmentStack.isEmpty()) {
                previousLabel = ((ContainmentStruct)this.containmentStack.lastElement()).getLabel();
            }
            if (previousLabel != null) {
                label = previousLabel + "." + (String)label;
            }
            ContainmentStruct containmentStruct = new ContainmentStruct((String)label, this.pathStackDump());
            this.containmentStack.push(containmentStruct);
        }
    }

    public void popStacks() {
        this.log.debug("-- POP PATH:" + (this.pathStack.isEmpty() ? "*empty*" : this.pathStack.getLast()));
        String path = this.popStack(this.pathStack);
        if (path != null && this.isArchetypeSlot(path)) {
            this.flushContainmentMap();
            this.containmentStack.pop();
        }
        this.popStack(this.namedStack);
    }

    private void pushStack(Deque<String> stack, String s) {
        stack.push(s);
    }

    private String popStack(Deque<String> stack) {
        if (!stack.isEmpty()) {
            return stack.pop();
        }
        return null;
    }

    private String stackDump(Deque stack) {
        StringBuilder b = new StringBuilder();
        for (Object s : stack.toArray()) {
            b.append((String)s);
        }
        return b.toString();
    }

    public String namedStackDump() {
        StringBuilder b = new StringBuilder();
        for (Object s : this.namedStack.toArray()) {
            b.append(s).append("/");
        }
        return b.toString();
    }

    public String expandedStackDump() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        String[] pathArray = this.pathStack.toArray(new String[0]);
        for (Object s : this.namedStack.toArray()) {
            b.append(s).append("{{").append(pathArray[i++]).append("}}/");
        }
        return b.toString();
    }

    public String pathStackDump() {
        return this.stackDump(this.pathStack);
    }

    private class ContainmentStruct {
        private String label;
        private String fullPath;

        ContainmentStruct(String archetype, String path) {
            this.label = archetype;
            this.fullPath = path;
        }

        public String getLabel() {
            return this.label;
        }

        String getFullPath() {
            return this.fullPath;
        }
    }
}

