/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.dbencoding;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Action;
import com.nedap.archie.rm.composition.Activity;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.ContentItem;
import com.nedap.archie.rm.composition.Evaluation;
import com.nedap.archie.rm.composition.Instruction;
import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import java.util.Map;
import org.ehrbase.serialisation.dbencoding.CompositionSerializer;
import org.ehrbase.serialisation.dbencoding.NameAsDvText;
import org.ehrbase.serialisation.dbencoding.NodeEncoding;
import org.ehrbase.serialisation.dbencoding.SerialTree;

public class EntrySerialTree
extends SerialTree {
    private final CompositionSerializer.WalkerOutputMode tagMode;

    public EntrySerialTree(Map<String, Object> map, CompositionSerializer.WalkerOutputMode tagMode) {
        super(map);
        this.tagMode = tagMode;
    }

    public Map<String, Object> insert(Composition composition, String attribute, Object addStructure) {
        Map<String, Object> retMap;
        switch (attribute) {
            case "/composition": {
                retMap = super.insert(composition, new NodeEncoding(this.tagMode).tag("/composition", (Locatable)composition, this.map), addStructure);
                break;
            }
            default: {
                retMap = this.map;
            }
        }
        return retMap;
    }

    public Map<String, Object> insert(ContentItem contentItem, String attribute, Object addStructure) {
        Map<String, Object> retMap;
        switch (attribute) {
            case "/content": {
                if (addStructure != null && !((Map)addStructure).containsKey("/name")) {
                    ((Map)addStructure).put("/name", new NameAsDvText(contentItem.getName()).toMap());
                }
                retMap = super.insert(contentItem, new NodeEncoding(this.tagMode).tag("/content", (Locatable)contentItem, this.map), addStructure);
                break;
            }
            default: {
                retMap = this.map;
            }
        }
        return retMap;
    }

    public Map<String, Object> insert(Observation observation, String attribute, Object addStructure) {
        Map<String, Object> retMap;
        switch (attribute) {
            case "/protocol": {
                retMap = super.insert(observation, new NodeEncoding(this.tagMode).tag("/protocol", (Locatable)observation.getProtocol(), this.map), addStructure);
                break;
            }
            case "/data": {
                retMap = super.insert(observation, new NodeEncoding(this.tagMode).tag("/data", (Locatable)observation.getData(), this.map), addStructure);
                break;
            }
            case "/state": {
                retMap = super.insert(observation, new NodeEncoding(this.tagMode).tag("/state", (Locatable)observation.getState(), this.map), addStructure);
                break;
            }
            default: {
                retMap = this.map;
            }
        }
        return retMap;
    }

    public Map<String, Object> insert(Evaluation evaluation, String attribute, Object addStructure) {
        Map<String, Object> retMap;
        switch (attribute) {
            case "/protocol": {
                retMap = super.insert(evaluation, new NodeEncoding(this.tagMode).tag("/protocol", (Locatable)evaluation.getProtocol(), this.map), addStructure);
                break;
            }
            case "/data": {
                retMap = super.insert(evaluation, new NodeEncoding(this.tagMode).tag("/data", (Locatable)evaluation.getData(), this.map), addStructure);
                break;
            }
            default: {
                retMap = this.map;
            }
        }
        return retMap;
    }

    public Map<String, Object> insert(Instruction instruction, String attribute, Object addStructure) {
        Map<String, Object> retMap;
        switch (attribute) {
            case "/protocol": {
                retMap = super.insert(instruction, new NodeEncoding(this.tagMode).tag("/protocol", (Locatable)instruction.getProtocol(), this.map), addStructure);
                break;
            }
            case "/activities": {
                retMap = super.insert(instruction, "/activities", addStructure);
                break;
            }
            default: {
                retMap = this.map;
            }
        }
        return retMap;
    }

    public Map<String, Object> insert(Activity activity, String attribute, Object addStructure) {
        Map<String, Object> retMap;
        switch (attribute) {
            case "/activities": {
                retMap = super.insert(activity, new NodeEncoding(this.tagMode).tag("/activities", (Locatable)activity, this.map), addStructure);
                break;
            }
            case "/description": {
                retMap = super.insert(activity, new NodeEncoding(this.tagMode).tag("/description", (Locatable)activity.getDescription(), this.map), addStructure);
                break;
            }
            default: {
                retMap = this.map;
            }
        }
        return retMap;
    }

    public Map<String, Object> insert(Action action, String attribute, Object addStructure) {
        Map<String, Object> retMap;
        switch (attribute) {
            case "/protocol": {
                retMap = super.insert(action, new NodeEncoding(this.tagMode).tag("/protocol", (Locatable)action.getProtocol(), this.map), addStructure);
                break;
            }
            case "/description": {
                retMap = super.insert(action, new NodeEncoding(this.tagMode).tag("/description", (Locatable)action.getDescription(), this.map), addStructure);
                break;
            }
            default: {
                retMap = this.map;
            }
        }
        return retMap;
    }

    public Map<String, Object> insert(History<?> history, String attribute, Object addStructure) {
        Map<String, Object> retMap;
        switch (attribute) {
            case "/summary": {
                retMap = super.insert(history, new NodeEncoding(this.tagMode).tag("/summary", (Locatable)history, this.map), addStructure);
                break;
            }
            case "/events": {
                retMap = super.insert(history, new NodeEncoding(this.tagMode).tag("/events", null, this.map), addStructure);
                break;
            }
            default: {
                retMap = this.map;
            }
        }
        return retMap;
    }

    public Map<String, Object> insert(Event<?> event, String attribute, Object addStructure) {
        Map<String, Object> retMap;
        switch (attribute) {
            case "/data": {
                retMap = super.insert(event, new NodeEncoding(this.tagMode).tag("/data", (Locatable)event.getData(), this.map), addStructure);
                break;
            }
            case "/state": {
                retMap = super.insert(event, new NodeEncoding(this.tagMode).tag("/state", (Locatable)event.getState(), this.map), addStructure);
                break;
            }
            default: {
                retMap = this.map;
            }
        }
        return retMap;
    }
}

