/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.dbencoding;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Action;
import com.nedap.archie.rm.composition.Activity;
import com.nedap.archie.rm.composition.AdminEntry;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.ContentItem;
import com.nedap.archie.rm.composition.Evaluation;
import com.nedap.archie.rm.composition.Instruction;
import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.composition.Section;
import com.nedap.archie.rm.datastructures.Cluster;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datastructures.Item;
import com.nedap.archie.rm.datastructures.ItemList;
import com.nedap.archie.rm.datastructures.ItemSingle;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datastructures.ItemTable;
import com.nedap.archie.rm.datastructures.ItemTree;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.integration.GenericEntry;
import java.util.Map;
import org.ehrbase.serialisation.attributes.ActionAttributes;
import org.ehrbase.serialisation.attributes.ActivityAttributes;
import org.ehrbase.serialisation.attributes.AdminEntryAttributes;
import org.ehrbase.serialisation.attributes.ClusterAttributes;
import org.ehrbase.serialisation.attributes.ElementAttributes;
import org.ehrbase.serialisation.attributes.EvaluationAttributes;
import org.ehrbase.serialisation.attributes.EventAttributes;
import org.ehrbase.serialisation.attributes.HistoryAttributes;
import org.ehrbase.serialisation.attributes.InstructionAttributes;
import org.ehrbase.serialisation.attributes.ItemStructureAttributes;
import org.ehrbase.serialisation.attributes.ObservationAttributes;
import org.ehrbase.serialisation.attributes.SectionAttributes;
import org.ehrbase.serialisation.dbencoding.EncodeUtilArchie;
import org.ehrbase.serialisation.dbencoding.EntrySerialTree;
import org.ehrbase.serialisation.dbencoding.ItemStack;
import org.ehrbase.serialisation.dbencoding.MultiMap;
import org.ehrbase.serialisation.dbencoding.NodeEncoding;
import org.ehrbase.serialisation.dbencoding.PathMap;
import org.ehrbase.serialisation.dbencoding.SerialTree;
import org.ehrbase.serialisation.dbencoding.SimpleClassName;
import org.ehrbase.serialisation.exception.MarshalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositionSerializer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected ItemStack itemStack = new ItemStack();
    private final WalkerOutputMode tagMode = WalkerOutputMode.PATH;
    public static final String TAG_META = "/meta";
    public static final String TAG_CONTENT = "/content";
    public static final String TAG_PROTOCOL = "/protocol";
    public static final String TAG_DATA = "/data";
    public static final String TAG_STATE = "/state";
    public static final String TAG_DESCRIPTION = "/description";
    public static final String TAG_TIME = "/time";
    public static final String TAG_WIDTH = "/width";
    public static final String TAG_MATH_FUNCTION = "/math_function";
    public static final String TAG_INSTRUCTION = "/instruction";
    public static final String TAG_NARRATIVE = "/narrative";
    public static final String TAG_ITEMS = "/items";
    public static final String TAG_OTHER_CONTEXT = "/context/other_context";
    public static final String TAG_ACTIVITIES = "/activities";
    public static final String TAG_ACTIVITY = "/activity";
    public static final String TAG_VALUE = "/value";
    public static final String TAG_NULL_FLAVOUR = "/null_flavour";
    public static final String TAG_FEEDER_AUDIT = "/feeder_audit";
    public static final String TAG_EVENTS = "/events";
    public static final String TAG_ORIGIN = "/origin";
    public static final String TAG_SUMMARY = "/summary";
    public static final String TAG_TIMING = "/timing";
    public static final String TAG_COMPOSITION = "/composition";
    public static final String TAG_ENTRY = "/entry";
    public static final String TAG_EVALUATION = "/evaluation";
    public static final String TAG_OBSERVATION = "/observation";
    public static final String TAG_ACTION = "/action";
    public static final String TAG_SUBJECT = "/subject";
    public static final String TAG_LANGUAGE = "/language";
    public static final String TAG_ENCODING = "/encoding";
    public static final String TAG_ISM_TRANSITION = "/ism_transition";
    public static final String TAG_CURRENT_STATE = "/current_state";
    public static final String TAG_CAREFLOW_STEP = "/careflow_step";
    public static final String TAG_ISM_TRANSITION_REASON = "/careflow_step";
    public static final String TAG_TRANSITION = "/transition";
    public static final String TAG_WORKFLOW_ID = "/workflow_id";
    public static final String TAG_GUIDELINE_ID = "/guideline_id";
    public static final String TAG_OTHER_PARTICIPATIONS = "/other_participations";
    public static final String TAG_PROVIDER = "/provider";
    public static final String TAG_UID = "/uid";
    public static final String TAG_OTHER_DETAILS = "/other_details";
    public static final String TAG_INSTRUCTION_DETAILS = "/instruction_details";
    public static final String TAG_ACTIVITY_ID = "/action_id";
    public static final String TAG_INSTRUCTION_ID = "/instruction_id";
    public static final String TAG_PATH = "/$PATH$";
    public static final String TAG_CLASS = "/$CLASS$";
    public static final String TAG_NAME = "/name";
    public static final String TAG_DEFINING_CODE = "/defining_code";
    public static final String INNER_CLASS_LIST = "$INNER_CLASS_LIST$";
    public static final String TAG_ACTION_ARCHETYPE_ID = "/action_archetype_id";
    public static final String TAG_ARCHETYPE_NODE_ID = "/archetype_node_id";
    public static final String TAG_LINKS = "/links";
    public static final String DEFAULT_NARRATIVE = "DEFAULT_NARRATIVE";
    public static final String TAG_ARCHETYPE_DETAILS = "/archetype_details";
    public static final String EPOCH_OFFSET = "epoch_offset";
    public static final DvText NO_NAME = null;

    private Map<String, Object> traverse(Composition composition) {
        Map<String, Object> ctree = PathMap.getInstance();
        if (composition == null) {
            return null;
        }
        Map<String, Object> ltree = MultiMap.getInstance();
        if (composition.getContent() != null && !composition.getContent().isEmpty()) {
            for (ContentItem item : composition.getContent()) {
                ltree = new EntrySerialTree(ltree, this.tagMode).insert(item, TAG_CONTENT, (Object)this.traverse(item, TAG_CONTENT));
            }
        }
        ltree.remove(TAG_CLASS);
        ltree.put(TAG_CLASS, new SimpleClassName(composition).toString());
        this.itemStack.popStacks();
        ctree = new EntrySerialTree(ctree, this.tagMode).insert(composition, TAG_COMPOSITION, (Object)ltree);
        return ctree;
    }

    private Map<String, Object> traverse(ContentItem item, String tag) {
        Map<String, Object> retmap = null;
        if (item == null) {
            return null;
        }
        this.log.debug("traverse element of class:" + item.getClass() + ", tag:" + tag + ", nodeid:" + item.getArchetypeNodeId());
        if (item.getArchetypeNodeId() == null || item.getArchetypeNodeId().isEmpty()) {
            throw new IllegalArgumentException("ContentItem mandatory attribute archetype_node_id null or empty, item:" + item);
        }
        if (item.getName() == null || item.getName().getValue().isEmpty()) {
            throw new IllegalArgumentException("ContentItem mandatory attribute name is null or empty, item:" + item.getArchetypeNodeId());
        }
        this.itemStack.pushStacks(tag + "[" + item.getArchetypeNodeId() + "]", item.getName().getValue());
        if (item instanceof Observation) {
            Observation observation = (Observation)item;
            Map<String, Object> ltree = PathMap.getInstance();
            if (observation.getProtocol() != null) {
                ltree = new EntrySerialTree(ltree, this.tagMode).insert(observation, TAG_PROTOCOL, (Object)this.traverse(observation.getProtocol(), TAG_PROTOCOL));
            }
            if (observation.getData() != null) {
                ltree = new EntrySerialTree(ltree, this.tagMode).insert(observation, TAG_DATA, (Object)this.traverse(observation.getData(), TAG_DATA));
            }
            if (observation.getState() != null) {
                ltree = new EntrySerialTree(ltree, this.tagMode).insert(observation, TAG_STATE, (Object)this.traverse(observation.getState(), TAG_STATE));
            }
            retmap = (ltree = new ObservationAttributes(this, this.itemStack, ltree).toMap(observation)).size() > 0 ? ltree : null;
        } else if (item instanceof Evaluation) {
            Evaluation evaluation = (Evaluation)item;
            Map<String, Object> ltree = PathMap.getInstance();
            if (evaluation.getProtocol() != null) {
                ltree = new EntrySerialTree(ltree, this.tagMode).insert(evaluation, TAG_PROTOCOL, (Object)this.traverse(evaluation.getProtocol(), TAG_PROTOCOL));
            }
            if (evaluation.getData() != null) {
                ltree = new EntrySerialTree(ltree, this.tagMode).insert(evaluation, TAG_DATA, (Object)this.traverse(evaluation.getData(), TAG_DATA));
            }
            retmap = (ltree = new EvaluationAttributes(this, this.itemStack, ltree).toMap(evaluation)).size() > 0 ? ltree : null;
        } else if (item instanceof Instruction) {
            Map<String, Object> ltree = PathMap.getInstance();
            Instruction instruction = (Instruction)item;
            if (instruction.getProtocol() != null) {
                ltree = new SerialTree(ltree).insert(instruction, new NodeEncoding(this.tagMode).tag(TAG_PROTOCOL, (Locatable)((Instruction)item).getProtocol(), ltree), this.traverse(instruction.getProtocol(), TAG_PROTOCOL));
            }
            ltree = new InstructionAttributes(this, this.itemStack, ltree).toMap(instruction);
            if (instruction.getActivities() != null) {
                Map<String, Object> activities = MultiMap.getInstance();
                for (Activity activity : instruction.getActivities()) {
                    this.itemStack.pushStacks("/activities[" + activity.getArchetypeNodeId() + "]", activity.getName().getValue());
                    activities = new EntrySerialTree(activities, this.tagMode).insert(activity, TAG_ACTIVITIES, (Object)this.traverse(activity, TAG_DESCRIPTION));
                    this.itemStack.popStacks();
                }
                ltree = new EntrySerialTree(ltree, this.tagMode).insert(instruction, TAG_ACTIVITIES, (Object)activities);
            }
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof Action) {
            Map<String, Object> protocol;
            Map<String, Object> ltree = PathMap.getInstance();
            Action action = (Action)item;
            if (action.getProtocol() != null && (protocol = this.traverse(action.getProtocol(), TAG_PROTOCOL)) != null) {
                ltree = new EntrySerialTree(ltree, this.tagMode).insert(action, TAG_PROTOCOL, (Object)this.traverse(action.getProtocol(), TAG_PROTOCOL));
            }
            if (action.getDescription() != null) {
                Map<String, Object> description = this.traverse(action.getDescription(), TAG_DESCRIPTION);
                if (description != null) {
                    ltree = new EntrySerialTree(ltree, this.tagMode).insert(action, TAG_DESCRIPTION, (Object)this.traverse(action.getDescription(), TAG_DESCRIPTION));
                }
            } else {
                this.log.warn("ACTION requires attribute 'description' at node:" + this.itemStack.pathStackDump());
            }
            ltree = new ActionAttributes(this, this.itemStack, ltree).toMap(action);
            if (!ltree.containsKey(TAG_CLASS)) {
                ltree.put(TAG_CLASS, new SimpleClassName(item).toString());
            }
            retmap = ltree;
        } else if (item instanceof Section) {
            Map<String, Object> ltree = MultiMap.getInstance();
            for (ContentItem contentItem : ((Section)item).getItems()) {
                this.log.debug("ltree now:" + ((ltree = new SerialTree(ltree).insert(contentItem, new NodeEncoding(this.tagMode).tag(TAG_ITEMS, (Locatable)contentItem, ltree), this.traverse(contentItem, TAG_ITEMS))) != null));
            }
            ltree = new SectionAttributes(this, this.itemStack, ltree).toMap((Section)item);
            ltree.remove(TAG_CLASS);
            ltree.put(TAG_CLASS, new SimpleClassName(item).toString());
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof AdminEntry) {
            AdminEntry adminEntry = (AdminEntry)item;
            Map<String, Object> ltree = PathMap.getInstance();
            if (adminEntry.getData() != null) {
                ltree = new SerialTree(ltree).insert(adminEntry, new NodeEncoding(this.tagMode).tag(TAG_DATA, (Locatable)adminEntry.getData(), ltree), this.traverse(adminEntry.getData(), TAG_DATA));
            }
            retmap = (ltree = new AdminEntryAttributes(this, this.itemStack, ltree).toMap(adminEntry)).size() > 0 ? ltree : null;
        } else if (item instanceof GenericEntry) {
            Map<String, Object> ltree = PathMap.getInstance();
            GenericEntry genericEntry = (GenericEntry)item;
            retmap = (ltree = new SerialTree(ltree).insert(genericEntry, new NodeEncoding(this.tagMode).tag(TAG_DATA, (Locatable)genericEntry.getData(), ltree), this.traverse((ItemStructure)genericEntry.getData(), TAG_DATA))).size() > 0 ? ltree : null;
        } else {
            this.log.warn("This item is not handled!" + item.getNameAsString());
        }
        this.itemStack.popStacks();
        return retmap;
    }

    private Map<String, Object> traverse(Activity activity, String tag) {
        if (activity == null) {
            return null;
        }
        this.log.debug("traverse activity:" + activity);
        if (activity.getDescription() == null) {
            throw new IllegalArgumentException("Invalid activity, no description found:" + activity.getNameAsString());
        }
        Map<String, Object> ltree = PathMap.getInstance();
        ltree = new ActivityAttributes(this, this.itemStack, ltree).toMap(activity);
        this.itemStack.pushStacks(tag + "[" + activity.getDescription().getArchetypeNodeId() + "]", activity.getDescription().getName().getValue());
        this.log.debug(this.itemStack.pathStackDump() + "/description[" + activity.getArchetypeNodeId() + "]=" + activity.getDescription().toString());
        ltree = new EntrySerialTree(ltree, this.tagMode).insert(activity, TAG_DESCRIPTION, (Object)this.traverse(activity.getDescription(), null));
        if (activity.getActionArchetypeId() != null) {
            ltree = new SerialTree(ltree).insert(new SimpleClassName(activity.getActionArchetypeId()).toString(), activity, TAG_ACTION_ARCHETYPE_ID, activity.getActionArchetypeId().trim());
        }
        this.itemStack.popStacks();
        return ltree;
    }

    private Map<String, Object> traverse(History<?> history, String tag) {
        if (history == null) {
            return null;
        }
        this.log.debug("traverse history:" + history);
        this.itemStack.pushStacks(tag + "[" + history.getArchetypeNodeId() + "]", history.getName().getValue());
        Map<String, Object> ltree = PathMap.getInstance();
        this.log.debug(this.itemStack.pathStackDump() + "/origin[" + history.getArchetypeNodeId() + "]=" + history.getOrigin());
        ltree = new HistoryAttributes(this, this.itemStack, ltree).toMap(history);
        if (history.getSummary() != null) {
            ltree = new EntrySerialTree(ltree, this.tagMode).insert(history, TAG_SUMMARY, (Object)this.traverse(history.getSummary(), TAG_SUMMARY));
        }
        if (history.getEvents() != null) {
            Map<String, Object> eventtree = MultiMap.getInstance();
            for (Event event : history.getEvents()) {
                this.itemStack.pushStacks("/events[" + event.getArchetypeNodeId() + "]", event.getName().getValue());
                Map<String, Object> subtree = PathMap.getInstance();
                this.log.debug(this.itemStack.pathStackDump() + "/time[" + event.getArchetypeNodeId() + "]=" + event.getTime());
                subtree = new EventAttributes(this, this.itemStack, subtree).toMap(event);
                if (event.getData() != null) {
                    subtree = new EntrySerialTree(subtree, this.tagMode).insert((Event<?>)event, TAG_DATA, (Object)this.traverse(event.getData(), TAG_DATA));
                }
                if (event.getState() != null) {
                    subtree = new EntrySerialTree(subtree, this.tagMode).insert((Event<?>)event, TAG_STATE, (Object)this.traverse(event.getState(), TAG_STATE));
                }
                if (!subtree.containsKey(TAG_CLASS)) {
                    this.log.warn("Inserting class type, potentially a test case?");
                    subtree.put(TAG_CLASS, new SimpleClassName(event).toString());
                }
                this.itemStack.popStacks();
                eventtree = new SerialTree(eventtree).insert(null, event, new NodeEncoding(this.tagMode).tag(TAG_EVENTS, (Locatable)event, eventtree), subtree);
            }
            ltree = new EntrySerialTree(ltree, this.tagMode).insert(history, TAG_EVENTS, (Object)eventtree);
        }
        this.itemStack.popStacks();
        return ltree;
    }

    private Map<String, Object> compactEntry(Object node, Map<String, Object> target, String key, Map<String, Object> entry) {
        if (entry != null && !entry.isEmpty()) {
            if (entry.keySet().size() == 1 && entry.get(TAG_VALUE) != null) {
                Object o = entry.get(TAG_VALUE);
                target = new SerialTree(target).insert(null, null, key, o);
            } else {
                target = new SerialTree(target).insert(new SimpleClassName(node).toString(), null, key, entry);
            }
        }
        return target;
    }

    private Map<String, Object> traverse(ItemStructure item, String uppertag) {
        Map<String, Object> retmap = null;
        this.log.debug("traverse itemstructure:" + item);
        if (item == null) {
            return null;
        }
        if (uppertag != null) {
            this.itemStack.pushStacks(uppertag + "[" + item.getArchetypeNodeId() + "]", item.getNameAsString());
        }
        if (item instanceof ItemSingle) {
            Map<String, Object> ltree = PathMap.getInstance();
            ItemSingle itemSingle = (ItemSingle)item;
            if (itemSingle.getItem() != null) {
                ltree = this.compactEntry(itemSingle, ltree, new NodeEncoding(this.tagMode).tag(TAG_ITEMS, (Locatable)itemSingle, ltree), this.traverse((Item)itemSingle.getItem(), TAG_ITEMS));
            }
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof ItemList) {
            Map<String, Object> ltree = MultiMap.getInstance();
            ItemList list = (ItemList)item;
            if (list.getItems() != null) {
                for (Item listItem : list.getItems()) {
                    ltree = this.compactEntry(listItem, ltree, new NodeEncoding(this.tagMode).tag(TAG_ITEMS, (Locatable)listItem, ltree), this.traverse(listItem, TAG_ITEMS));
                }
            }
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof ItemTree) {
            Map<String, Object> ltree = MultiMap.getInstance();
            ItemTree tree = (ItemTree)item;
            if (tree.getItems() != null) {
                for (Item subItem : tree.getItems()) {
                    ltree = this.compactEntry(subItem, ltree, new NodeEncoding(this.tagMode).tag(TAG_ITEMS, (Locatable)subItem, ltree), this.traverse(subItem, TAG_ITEMS));
                }
            }
            retmap = ltree.size() > 0 ? ltree : null;
        } else if (item instanceof ItemTable) {
            Map<String, Object> ltree = MultiMap.getInstance();
            ItemTable table = (ItemTable)item;
            if (table.getRows() != null) {
                for (Item subItem : table.getRows()) {
                    ltree = this.compactEntry(subItem, ltree, new NodeEncoding(this.tagMode).tag(TAG_ITEMS, (Locatable)subItem, ltree), this.traverse(subItem, TAG_ITEMS));
                }
            }
            retmap = ltree.size() > 0 ? ltree : null;
        }
        if (uppertag != null) {
            this.itemStack.popStacks();
        }
        if (retmap != null) {
            if (retmap.containsKey(TAG_CLASS)) {
                retmap.remove(TAG_CLASS);
            }
            retmap.put(TAG_CLASS, new SimpleClassName(item).toString());
            retmap = new ItemStructureAttributes(this, this.itemStack, retmap).toMap((Locatable)item);
        }
        return retmap;
    }

    private Map<String, Object> traverse(Item item, String tag) {
        Map<String, Object> retmap = PathMap.getInstance();
        this.log.debug("traverse item:" + item);
        if (item == null) {
            return null;
        }
        if (item instanceof Element) {
            this.itemStack.pushStacks(tag + "[" + item.getArchetypeNodeId() + "]", null);
            retmap = new ElementAttributes(this, this.itemStack, retmap).toMap((Element)item);
            this.itemStack.popStacks();
        } else if (item instanceof Cluster) {
            Map<String, Object> ltree = MultiMap.getInstance();
            this.itemStack.pushStacks(tag + "[" + item.getArchetypeNodeId() + "]", item.getNameAsString());
            Cluster cluster = (Cluster)item;
            boolean hasContent = false;
            if (cluster.getItems() != null) {
                for (Object itemInList : cluster.getItems()) {
                    if (itemInList instanceof Item) {
                        Item clusterItem = (Item)itemInList;
                        Map<String, Object> clusterItems = this.traverse(clusterItem, TAG_ITEMS);
                        if (clusterItems == null) continue;
                        if (clusterItems.containsKey(TAG_CLASS)) {
                            clusterItems.put(TAG_CLASS, item.getClass().getSimpleName());
                        }
                        ltree.put(new NodeEncoding(this.tagMode).tag(TAG_ITEMS, (Locatable)clusterItem, ltree), clusterItems.getOrDefault(TAG_VALUE, clusterItems));
                        continue;
                    }
                    throw new IllegalArgumentException("Found non item in cluster");
                }
                if (ltree.size() > 0) {
                    hasContent = true;
                }
                if (!(ltree = new ClusterAttributes(this, this.itemStack, ltree).toMap((Locatable)cluster)).containsKey(TAG_CLASS)) {
                    ltree.put(TAG_CLASS, Cluster.class.getSimpleName());
                }
            }
            retmap = hasContent ? ltree : null;
            this.itemStack.popStacks();
        }
        return retmap;
    }

    public String dbEncode(RMObject rmObject) {
        Map<String, Object> objectMap;
        if (rmObject instanceof Composition) {
            objectMap = this.traverse((Composition)rmObject);
        } else if (rmObject instanceof Item) {
            objectMap = this.traverse((Item)rmObject, TAG_ITEMS);
        } else if (rmObject instanceof ItemStructure) {
            objectMap = this.traverse((ItemStructure)rmObject, TAG_ITEMS);
            if (objectMap != null && !objectMap.containsKey(TAG_ARCHETYPE_NODE_ID) && ((ItemStructure)rmObject).getArchetypeNodeId() != null) {
                objectMap.put(TAG_ARCHETYPE_NODE_ID, ((ItemStructure)rmObject).getArchetypeNodeId());
            }
            if (objectMap != null && !objectMap.containsKey(TAG_NAME) && ((ItemStructure)rmObject).getName() != null) {
                objectMap.put(TAG_NAME, ((ItemStructure)rmObject).getName());
            }
        } else {
            throw new MarshalException(String.format("Class %s not supported ", rmObject.getClass()), null);
        }
        GsonBuilder builder = EncodeUtilArchie.getGsonBuilderInstance();
        Gson gson = builder.setPrettyPrinting().create();
        return gson.toJson(objectMap);
    }

    public Map<String, String> getLtreeMap() {
        return this.itemStack.getLtreeMap();
    }

    public WalkerOutputMode tagMode() {
        return this.tagMode;
    }

    public static enum WalkerOutputMode {
        PATH,
        NAMED,
        EXPANDED,
        RAW;

    }
}

