/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.attributes;

import com.nedap.archie.rm.archetyped.Locatable;
import java.util.Map;
import org.apache.commons.collections.map.MultiValueMap;
import org.ehrbase.serialisation.attributes.FeederAuditAttributes;
import org.ehrbase.serialisation.attributes.LinksAttributes;
import org.ehrbase.serialisation.attributes.RMAttributes;
import org.ehrbase.serialisation.dbencoding.CompositionSerializer;
import org.ehrbase.serialisation.dbencoding.ItemStack;
import org.ehrbase.serialisation.dbencoding.NameAsDvText;
import org.ehrbase.serialisation.dbencoding.NameInMap;

public abstract class LocatableAttributes
extends RMAttributes {
    public LocatableAttributes(CompositionSerializer compositionSerializer, ItemStack itemStack, Map<String, Object> map) {
        super(compositionSerializer, itemStack, map);
    }

    protected Map<String, Object> toMap(Locatable locatable) {
        if (locatable.getArchetypeNodeId() != null) {
            this.map.put("/archetype_node_id", locatable.getArchetypeNodeId());
        }
        if (locatable.getArchetypeDetails() != null) {
            this.map.put("/archetype_details", locatable.getArchetypeDetails());
        }
        if (locatable.getFeederAudit() != null) {
            this.map.put("/feeder_audit", new FeederAuditAttributes(locatable.getFeederAudit()).toMap());
        }
        if (locatable.getUid() != null) {
            this.map = this.toMap("/uid", locatable.getUid(), CompositionSerializer.NO_NAME);
        }
        if (locatable.getLinks() != null && !locatable.getLinks().isEmpty()) {
            this.map.put("/links", new LinksAttributes(locatable.getLinks()).toMap());
        }
        if (!this.map.containsKey("/name") && locatable.getName() != null) {
            if (this.map instanceof MultiValueMap) {
                this.map.put("/name", new NameAsDvText(locatable.getName()).toMap());
            } else {
                new NameInMap(this.map, new NameAsDvText(locatable.getName()).toMap()).toMap();
            }
        }
        return this.map;
    }

    public static boolean isLocatableAttribute(String key) {
        return key.equals("/archetype_node_id") || key.equals("/archetype_details") || key.equals("/feeder_audit") || key.equals("/uid") || key.equals("/links") || key.equals("/name");
    }
}

