/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.attributes;

import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datavalues.DvText;
import java.util.Map;
import org.ehrbase.serialisation.attributes.ItemAttributes;
import org.ehrbase.serialisation.dbencoding.CompositeClassName;
import org.ehrbase.serialisation.dbencoding.CompositionSerializer;
import org.ehrbase.serialisation.dbencoding.ItemStack;
import org.ehrbase.serialisation.dbencoding.PathItem;
import org.ehrbase.serialisation.dbencoding.PathMap;
import org.ehrbase.serialisation.dbencoding.SerialTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementAttributes
extends ItemAttributes {
    private static final String INITIAL_DUMMY_PREFIX = "$*>";
    private boolean allElements = false;
    private Logger log = LoggerFactory.getLogger((String)ElementAttributes.class.getSimpleName());

    public ElementAttributes(CompositionSerializer compositionSerializer, ItemStack itemStack, Map<String, Object> map) {
        super(compositionSerializer, itemStack, map);
    }

    public Map<String, Object> toMap(Element element) {
        Map ltree = this.map;
        if (element.getName().getValue().startsWith(INITIAL_DUMMY_PREFIX)) {
            if (this.allElements) {
                DvText elementName = element.getName();
                elementName.setValue(elementName.getValue().substring(INITIAL_DUMMY_PREFIX.length()));
                element.setName(elementName);
            } else {
                return ltree;
            }
        }
        Map<String, Object> valuemap = PathMap.getInstance();
        if (element.getValue() != null && !element.getValue().toString().isEmpty()) {
            this.log.debug(this.itemStack.pathStackDump() + "=" + element.getValue());
            if (element.getValue() != null && !element.getValue().toString().isEmpty()) {
                valuemap = new SerialTree(valuemap).insert(new CompositeClassName(element.getValue()).toString(), element, "/value", element.getValue());
            }
        } else if (element.getNullFlavour() != null) {
            valuemap = new SerialTree(valuemap).insert(null, element, "/null_flavour", element.getNullFlavour());
        }
        valuemap = new PathItem(valuemap, this.tagMode, this.itemStack).encode(null);
        valuemap.put("/archetype_node_id", element.getArchetypeNodeId());
        ltree.put("/value", valuemap);
        return ltree;
    }
}

