/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.building;

import com.google.common.reflect.TypeToken;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.creation.RMObjectCreator;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.archetyped.TemplateId;
import com.nedap.archie.rm.composition.Activity;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.encapsulated.DvParsable;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.Participation;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.ArchetypeID;
import com.nedap.archie.rm.support.identification.TerminologyId;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.xmlbeans.XmlObject;
import org.ehrbase.building.rmobjectskeletonbuilder.RmObjectSkeletonBuilder;
import org.ehrbase.serialisation.util.SnakeCase;
import org.ehrbase.terminology.openehr.implementation.LocalizedTerminologies;
import org.ehrbase.util.reflection.ReflectionHelper;
import org.ehrbase.webtemplate.parser.OptNameHelper;
import org.ehrbase.webtemplate.parser.config.RmIntrospectConfig;
import org.openehr.schemas.v1.ARCHETYPESLOT;
import org.openehr.schemas.v1.ARCHETYPETERM;
import org.openehr.schemas.v1.CARCHETYPEROOT;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCODEPHRASE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CDOMAINTYPE;
import org.openehr.schemas.v1.CMULTIPLEATTRIBUTE;
import org.openehr.schemas.v1.COBJECT;
import org.openehr.schemas.v1.CPRIMITIVEOBJECT;
import org.openehr.schemas.v1.CSINGLEATTRIBUTE;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.StringDictionaryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptSkeletonBuilder {
    private static final ArchieRMInfoLookup RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    private static final RMObjectCreator RM_CREATOR = new RMObjectCreator((ModelInfoLookup)RM_INFO_LOOKUP);
    private static final LocalizedTerminologies LOCALIZED_TERMINOLOGIES;
    private static final Map<Class<?>, RmIntrospectConfig> configMap;
    private static final Map<Class<?>, RmObjectSkeletonBuilder> builderMap;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    private Object buildSkeletonForTerminalRmObjects(XmlObject cpo) {
        RmObjectSkeletonBuilder rmObjectSkeletonBuilder = builderMap.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(cpo.getClass())).findAny().map(Map.Entry::getValue).orElseThrow(() -> new RuntimeException(String.format("No builder for {%s}", cpo.getClass())));
        return rmObjectSkeletonBuilder.getRmObject(cpo);
    }

    public RMObject generate(OPERATIONALTEMPLATE opt) {
        CARCHETYPEROOT def = opt.getDefinition();
        Object c = this.handleArchetypeRoot(opt, def, "");
        return (RMObject)c;
    }

    private Object handleArchetypeRoot(OPERATIONALTEMPLATE opt, CARCHETYPEROOT def, String path) {
        HashMap<String, String> termDef = new HashMap<String, String>();
        for (ARCHETYPETERM term : def.getTermDefinitionsArray()) {
            String code = term.getCode();
            for (StringDictionaryItem item : term.getItemsArray()) {
                if (!"text".equals(item.getId())) continue;
                termDef.put(code, item.getStringValue());
            }
        }
        this.log.debug("CARCHETYPEROOT path= {}", (Object)path);
        return this.handleComplexObject(opt, (CCOMPLEXOBJECT)def, termDef, path);
    }

    private Object handleComplexObject(OPERATIONALTEMPLATE opt, CCOMPLEXOBJECT ccobj, Map<String, String> termDef, String path) {
        Object obj;
        Class rmClass;
        CATTRIBUTE[] cattributes;
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("template_id", opt.getTemplateId().getValue());
        String rmTypeName = ccobj.getRmTypeName();
        this.log.debug("rmTypeName={}:nodeId={}:ccobj={}", new Object[]{rmTypeName, ccobj.getNodeId(), ccobj});
        this.addNodeId(ccobj, termDef, valueMap);
        for (CATTRIBUTE attr : cattributes = ccobj.getAttributesArray()) {
            String pathloop = path + "/" + attr.getRmAttributeName();
            COBJECT[] children = attr.getChildrenArray();
            String attrName = attr.getRmAttributeName();
            if (attr instanceof CSINGLEATTRIBUTE && !pathloop.endsWith("/name")) {
                if (children == null || children.length <= 0) continue;
                try {
                    COBJECT cobj = children[0];
                    if (children.length > 1) {
                        this.log.debug("Multiple children in CATTRIBUTE:{}", (Object)children.length);
                    }
                    Object attrValue = this.handleCObject(opt, cobj, termDef, pathloop);
                    this.log.debug("attrName={}: attrValue={}", (Object)attrName, attrValue);
                    if (attrValue == null) continue;
                    valueMap.put(attr.getRmAttributeName(), attrValue);
                }
                catch (Exception e) {
                    this.log.error(String.format("Cannot create attribute name %s on path %s", attrName, pathloop), (Throwable)e);
                }
                continue;
            }
            if (!(attr instanceof CMULTIPLEATTRIBUTE)) continue;
            ArrayList<Object> container = new ArrayList<Object>();
            for (COBJECT cobj : children) {
                try {
                    Object attrValue = this.handleCObject(opt, cobj, termDef, pathloop);
                    this.log.debug("attrName={}: attrValue={}", (Object)attrName, attrValue);
                    if (attrValue == null) continue;
                    container.add(attrValue);
                }
                catch (Exception e) {
                    this.log.error("Cannot create attribute name " + attrName + " on path " + pathloop, (Throwable)e);
                }
            }
            this.log.debug("valueMap.put {} :{}", (Object)attr.getRmAttributeName(), container);
            valueMap.put(attr.getRmAttributeName(), container);
        }
        if ("EVENT".equals(rmTypeName)) {
            rmTypeName = "POINT_EVENT";
        }
        if (Pathable.class.isAssignableFrom(rmClass = RM_INFO_LOOKUP.getClass(rmTypeName))) {
            this.handelNonTemplateFields(rmClass, valueMap);
        }
        try {
            CComplexObject elementConstraint = new CComplexObject();
            elementConstraint.setRmTypeName(rmTypeName);
            obj = RM_CREATOR.create((CObject)elementConstraint);
            this.addFields(obj, valueMap, termDef, opt);
        }
        catch (Exception e) {
            obj = null;
            this.log.warn("Could not create instance of type:{} ,for nodeid={}, path:{} ,valueMap:{} ,details:{}", new Object[]{rmTypeName, ccobj.getNodeId(), path, valueMap, e.getMessage()});
        }
        return obj;
    }

    private void handelNonTemplateFields(Class<?> rmClass, Map<String, Object> valueMap) {
        RmIntrospectConfig introspectConfig = configMap.get(rmClass);
        if (introspectConfig != null) {
            Arrays.stream(FieldUtils.getAllFields(rmClass)).filter(f -> introspectConfig.getNonTemplateFields().contains(f.getName())).forEach(f -> {
                try {
                    Object value;
                    if (f.getType().equals(PartyProxy.class)) {
                        value = new PartyIdentified();
                    } else if (List.class.isAssignableFrom(f.getType())) {
                        value = new ArrayList();
                        Class unwarap = this.unwarap((Field)f);
                        ((List)value).add(unwarap.getConstructor(new Class[0]).newInstance(new Object[0]));
                    } else {
                        value = !f.getType().isPrimitive() && !Modifier.isAbstract(f.getType().getModifiers()) && !f.getType().equals(String.class) ? f.getType().getConstructor(new Class[0]).newInstance(new Object[0]) : null;
                    }
                    valueMap.computeIfAbsent(new SnakeCase(f.getName()).camelToSnake(), k -> value);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    this.log.warn(e.getMessage());
                }
            });
        } else {
            this.log.debug("No RmIntrospectConfig for {}", rmClass);
        }
    }

    public Class unwarap(Field field) {
        if (List.class.isAssignableFrom(field.getType())) {
            Type actualTypeArgument = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            return TypeToken.of((Type)actualTypeArgument).getRawType();
        }
        return field.getType();
    }

    private void addFields(Object obj, Map<String, Object> valueMap, Map<String, String> termDef, OPERATIONALTEMPLATE opt) {
        Object value;
        for (Map.Entry<String, Object> e : valueMap.entrySet()) {
            try {
                value = e.getValue();
                List<Object> valueList = value instanceof List ? (List<Object>)value : Collections.singletonList(value);
                for (Object v : valueList) {
                    RM_CREATOR.addElementToListOrSetSingleValues(obj, e.getKey(), v);
                }
            }
            catch (Exception e2) {
                if (e2.getMessage().startsWith("Attribute template_id") || e2.getMessage().startsWith("Attribute archetype_node_id") || e2.getMessage().startsWith("Attribute name")) continue;
                this.log.warn(e2.getMessage());
            }
        }
        if (obj instanceof Entry) {
            ((Entry)obj).setEncoding(new CodePhrase(new TerminologyId("IANA_character-sets"), "UTF-8"));
        }
        if (obj instanceof Locatable && StringUtils.isBlank((CharSequence)((Locatable)obj).getName().getValue())) {
            ((Locatable)obj).getName().setValue(valueMap.getOrDefault("name", "").toString());
        }
        if (obj instanceof Activity) {
            ((Activity)obj).setTiming(new DvParsable());
        }
        if (obj instanceof Composition) {
            Archetyped archetypeDetails = new Archetyped();
            archetypeDetails.setTemplateId(new TemplateId());
            archetypeDetails.getTemplateId().setValue(opt.getTemplateId().getValue());
            archetypeDetails.setRmVersion("1.0.4");
            archetypeDetails.setArchetypeId(new ArchetypeID(((Composition)obj).getArchetypeNodeId()));
            ((Composition)obj).setArchetypeDetails(archetypeDetails);
            if (((Composition)obj).getContext() == null) {
                EventContext context = new EventContext();
                context.setEndTime(new DvDateTime());
                context.setStartTime(new DvDateTime());
                context.setHealthCareFacility(new PartyIdentified(null, null, new ArrayList()));
                context.setParticipations(new ArrayList());
                context.getParticipations().add(new Participation());
                context.setSetting(new DvCodedText());
                ((Composition)obj).setContext(context);
            }
        }
        if (obj instanceof DvCodedText) {
            DvCodedText dvCodedText = (DvCodedText)obj;
            Optional<CodePhrase> defining_code = Optional.ofNullable(valueMap.get("defining_code")).map(o -> (CodePhrase)o);
            value = defining_code.map(CodePhrase::getCodeString).map(termDef::get).orElse(defining_code.map(this::findByTerminologie).orElse(null));
            dvCodedText.setValue((String)value);
        }
    }

    public String findByTerminologie(CodePhrase codePhrase) {
        try {
            return LOCALIZED_TERMINOLOGIES.getDefault().terminology(codePhrase.getTerminologyId().getValue()).rubricForCode(codePhrase.getCodeString(), "en");
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private void addNodeId(CCOMPLEXOBJECT ccobj, Map<String, String> termDef, Map<String, Object> valueMap) {
        String nodeId = ccobj.getNodeId();
        if (nodeId != null && nodeId.trim().length() > 0) {
            DvText txtName = null;
            if (ccobj instanceof CARCHETYPEROOT) {
                this.log.debug("set archetype_node_id=" + ((CARCHETYPEROOT)ccobj).getArchetypeId().getValue());
                valueMap.put("archetype_node_id", ((CARCHETYPEROOT)ccobj).getArchetypeId().getValue());
                Optional name = OptNameHelper.extractName((CCOMPLEXOBJECT)ccobj);
                String termName = name.orElse(termDef.get(nodeId));
                if (termName != null) {
                    txtName = new DvText(termName);
                    valueMap.put("name", txtName);
                } else {
                    this.log.warn("name not found for nodeId {}", (Object)nodeId);
                }
                valueMap.put("name", txtName);
            } else {
                this.log.debug("set archetype_node_id={}", (Object)nodeId);
                valueMap.put("archetype_node_id", nodeId);
                Optional name = OptNameHelper.extractName((CCOMPLEXOBJECT)ccobj);
                String termName = name.orElse(termDef.get(nodeId));
                if (termName != null) {
                    txtName = new DvText(termName);
                    valueMap.put("name", txtName);
                } else {
                    this.log.warn("name not found for nodeId {}", (Object)nodeId);
                }
            }
        }
    }

    private Object handleCObject(OPERATIONALTEMPLATE opt, COBJECT cobj, Map<String, String> termDef, String path) {
        this.log.debug("cobj={}:{}", cobj.getClass(), (Object)cobj.getRmTypeName());
        if (cobj instanceof CARCHETYPEROOT) {
            if (!((CARCHETYPEROOT)cobj).getArchetypeId().getValue().isEmpty()) {
                path = (String)path + "[" + ((CARCHETYPEROOT)cobj).getArchetypeId().getValue() + "]";
            }
            this.log.debug("CARCHETYPEROOT path={}", path);
            return this.handleArchetypeRoot(opt, (CARCHETYPEROOT)cobj, (String)path);
        }
        if (cobj instanceof CDOMAINTYPE) {
            Object o = this.buildSkeletonForTerminalRmObjects((XmlObject)((CDOMAINTYPE)cobj));
            if (((String)path).contains("/category") && o instanceof CodePhrase) {
                CodePhrase codePhrase = (CodePhrase)o;
                CCODEPHRASE xml = (CCODEPHRASE)cobj;
                if (!ArrayUtils.isEmpty((Object[])xml.getCodeListArray()) && xml.getCodeListArray().length == 1 && xml.getTerminologyId() != null && xml.getTerminologyId().getValue() != null) {
                    codePhrase.setCodeString(xml.getCodeListArray(0));
                    codePhrase.setTerminologyId(new TerminologyId(xml.getTerminologyId().getValue()));
                }
            }
            return o;
        }
        if (cobj instanceof CCOMPLEXOBJECT) {
            if ("/category".equalsIgnoreCase((String)path)) {
                return this.handleComplexObject(opt, (CCOMPLEXOBJECT)cobj, termDef, (String)path);
            }
            if ("/context".equalsIgnoreCase((String)path)) {
                return this.handleComplexObject(opt, (CCOMPLEXOBJECT)cobj, termDef, (String)path);
            }
            if (!cobj.getNodeId().isEmpty()) {
                path = (String)path + "[" + cobj.getNodeId() + "]";
            }
            this.log.debug("CONTEXT path={}", path);
            return this.handleComplexObject(opt, (CCOMPLEXOBJECT)cobj, termDef, (String)path);
        }
        if (cobj instanceof ARCHETYPESLOT) {
            if (!cobj.getNodeId().isEmpty()) {
                path = (String)path + "[" + cobj.getNodeId() + "]";
            }
            this.log.debug("ARCHETYPESLOT path={}", path);
            return null;
        }
        if (cobj instanceof CPRIMITIVEOBJECT) {
            return this.buildSkeletonForTerminalRmObjects((XmlObject)cobj);
        }
        if (cobj.getNodeId() == null) {
            this.log.debug("NodeId is null : {}", (Object)cobj);
            return null;
        }
        this.log.debug("Some value cannot process because is not CARCHETYPEROOT or CCOMPLEXOBJECT : {}", (Object)cobj);
        return null;
    }

    static {
        try {
            LOCALIZED_TERMINOLOGIES = new LocalizedTerminologies();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        configMap = ReflectionHelper.buildMap(RmIntrospectConfig.class);
        builderMap = ReflectionHelper.buildMap(RmObjectSkeletonBuilder.class);
    }
}

