/*
 * Decompiled with CFR 0.152.
 */
package vimeoextractor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vimeoextractor.VimeoUser;

public class VimeoVideo {
    private String title;
    private long duration;
    private Map<String, String> streams = new HashMap<String, String>();
    private Map<String, String> thumbs = new HashMap<String, String>();
    private VimeoUser videoUser;

    protected VimeoVideo(@NotNull String json) {
        this.parseJson(json);
    }

    private void parseJson(String json) {
        try {
            JSONObject requestJson = new JSONObject(json);
            JSONObject videoInfo = requestJson.getJSONObject("video");
            this.duration = videoInfo.getLong("duration");
            this.title = videoInfo.getString("title");
            JSONObject userInfo = videoInfo.getJSONObject("owner");
            this.videoUser = new VimeoUser(userInfo);
            JSONObject thumbsInfo = videoInfo.getJSONObject("thumbs");
            Iterator iterator = thumbsInfo.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                this.thumbs.put(key, thumbsInfo.getString(key));
            }
            JSONArray streamArray = requestJson.getJSONObject("request").getJSONObject("files").getJSONArray("progressive");
            for (int streamIndex = 0; streamIndex < streamArray.length(); ++streamIndex) {
                JSONObject stream = streamArray.getJSONObject(streamIndex);
                String url = stream.getString("url");
                String quality = stream.getString("quality");
                this.streams.put(quality, url);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean hasStreams() {
        return this.streams.size() > 0;
    }

    public boolean isHD() {
        return this.streams.containsKey("1080p") || this.streams.containsKey("4096p");
    }

    public Map<String, String> getStreams() {
        return this.streams;
    }

    public boolean hasThumbs() {
        return this.thumbs.size() > 0;
    }

    public Map<String, String> getThumbs() {
        return this.thumbs;
    }

    public VimeoUser getVideoUser() {
        return this.videoUser;
    }
}

