/*
 * Decompiled with CFR 0.152.
 */
package pl.exsio.querydsl.entityql.entity.scanner;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.springframework.data.jdbc.core.mapping.JdbcMappingContext;
import org.springframework.data.jdbc.core.mapping.JdbcSimpleTypes;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import pl.exsio.querydsl.entityql.entity.metadata.QEntityColumnMetadata;
import pl.exsio.querydsl.entityql.entity.metadata.QEntityJoinColumnMetadata;
import pl.exsio.querydsl.entityql.entity.metadata.QEntityMetadata;
import pl.exsio.querydsl.entityql.entity.scanner.QEntityScanner;
import pl.exsio.querydsl.entityql.ex.MissingIdException;

public class SpringDataJdbcQEntityScanner
implements QEntityScanner {
    private final JdbcMappingContext context;

    public SpringDataJdbcQEntityScanner(NamingStrategy namingStrategy) {
        this.context = new JdbcMappingContext(namingStrategy);
    }

    @Override
    public QEntityMetadata scanEntity(Class<?> entityClass) {
        RelationalPersistentEntity requiredPersistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(entityClass);
        QEntityMetadata metadata = new QEntityMetadata(requiredPersistentEntity.getTableName(), this.context.getNamingStrategy().getSchema());
        this.setColumns(metadata, requiredPersistentEntity);
        return metadata;
    }

    private void setColumns(QEntityMetadata metadata, RelationalPersistentEntity<?> requiredPersistentEntity) {
        HashMap<String, Integer> fieldNameToIndex = new HashMap<String, Integer>();
        Field[] declaredFields = requiredPersistentEntity.getType().getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            fieldNameToIndex.put(declaredFields[i].getName(), i + 1);
        }
        requiredPersistentEntity.forEach(property -> {
            if ((property.isCollectionLike() || property.isMap()) && !property.getActualType().equals(Byte.TYPE)) {
                return;
            }
            if (this.isOneToOne((RelationalPersistentProperty)property)) {
                this.addJoinColumn(metadata, (RelationalPersistentProperty)property, (Map<String, Integer>)fieldNameToIndex);
            } else {
                this.addColumn(metadata, (RelationalPersistentProperty)property, (Map<String, Integer>)fieldNameToIndex);
            }
        });
        if (metadata.getIdColumns().isEmpty()) {
            throw new MissingIdException(requiredPersistentEntity.getType());
        }
    }

    private boolean isOneToOne(RelationalPersistentProperty property) {
        return property.isEntity() && !JdbcSimpleTypes.HOLDER.isSimpleType(property.getType());
    }

    private void addColumn(QEntityMetadata metadata, RelationalPersistentProperty property, Map<String, Integer> fieldNameToIndex) {
        QEntityColumnMetadata columnMetadata = new QEntityColumnMetadata(property.getType(), property.getName(), property.getColumnName(), this.isNullable(property), this.getIndex(property, fieldNameToIndex));
        metadata.addColumn(columnMetadata);
        if (property.isIdProperty()) {
            metadata.addIdColumn(columnMetadata);
        }
    }

    private void addJoinColumn(QEntityMetadata metadata, RelationalPersistentProperty property, Map<String, Integer> fieldNameToIndex) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(property.getActualType());
        PersistentPropertyPathExtension path = new PersistentPropertyPathExtension((MappingContext)this.context, Objects.requireNonNull(persistentEntity));
        String reverseColumnName = property.getReverseColumnName(path);
        QEntityJoinColumnMetadata column = new QEntityJoinColumnMetadata(property.getActualType(), property.getName(), reverseColumnName, this.isNullable(property), this.getIndex(property, fieldNameToIndex));
        metadata.addJoinColumn(column);
    }

    private Integer getIndex(RelationalPersistentProperty property, Map<String, Integer> fieldNameToIndex) {
        return fieldNameToIndex.get(property.getName());
    }

    private boolean isNullable(RelationalPersistentProperty property) {
        return !property.isAnnotationPresent(Nonnull.class);
    }
}

