/*
 * Decompiled with CFR 0.152.
 */
package pl.exsio.querydsl.entityql;

import com.google.common.collect.Lists;
import com.querydsl.sql.ColumnMetadata;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import pl.exsio.querydsl.entityql.EntityQL;
import pl.exsio.querydsl.entityql.Q;
import pl.exsio.querydsl.entityql.QColumnMetadataFactory;
import pl.exsio.querydsl.entityql.QFactory;
import pl.exsio.querydsl.entityql.QPath;
import pl.exsio.querydsl.entityql.QPathFactory;
import pl.exsio.querydsl.entityql.QSqlTypeProvider;
import pl.exsio.querydsl.entityql.entity.metadata.QEntityColumnMetadata;
import pl.exsio.querydsl.entityql.entity.metadata.QEntityCompositeJoinColumnMetadata;
import pl.exsio.querydsl.entityql.entity.metadata.QEntityJoinColumnMetadata;
import pl.exsio.querydsl.entityql.entity.metadata.ReferenceColumnInfoMetadata;
import pl.exsio.querydsl.entityql.entity.scanner.QEntityScanner;
import pl.exsio.querydsl.entityql.ex.InvalidArgumentException;

class QJoinColumn {
    private final LinkedHashMap<QPath, ColumnMetadata> paths = new LinkedHashMap();
    private final List<QEntityColumnMetadata> foreignColumns;
    private final QEntityScanner scanner;
    private final boolean inverse;
    private final LinkedList<String> columnNames = Lists.newLinkedList();
    private final Q<?> parent;

    QJoinColumn(Q<?> parent, QEntityJoinColumnMetadata column, QEntityScanner scanner, boolean inverse) {
        this.scanner = scanner;
        this.inverse = inverse;
        this.parent = parent;
        this.columnNames.add(column.getColumnName());
        this.foreignColumns = this.getForeignColumns(column);
        this.foreignColumns.forEach(foreignColumn -> this.createPath(parent, column.getFieldName(), column.getIdx(), column, (QEntityColumnMetadata)foreignColumn));
    }

    QJoinColumn(Q<?> parent, QEntityCompositeJoinColumnMetadata column, QEntityScanner scanner, boolean inverse) {
        this.scanner = scanner;
        this.inverse = inverse;
        this.parent = parent;
        column.getItems().forEach(item -> this.columnNames.add(item.getColumnName()));
        this.foreignColumns = this.getForeignColumns(column);
        if (this.foreignColumns.size() != column.getItems().size()) {
            throw new InvalidArgumentException(String.format("Unable to construct Foreign Columns out of: %s", column.getItems()));
        }
        for (int i = 0; i < this.foreignColumns.size(); ++i) {
            this.createPath(parent, column.getFieldName(), column.getIdx(), column.getItems().get(i), this.foreignColumns.get(i));
        }
    }

    private void createPath(Q<?> parent, String fieldName, int idx, ReferenceColumnInfoMetadata column, QEntityColumnMetadata foreignColumn) {
        QEntityColumnMetadata computedColumn = new QEntityColumnMetadata(foreignColumn.getOriginalFieldType(), fieldName, this.inverse ? foreignColumn.getColumnName() : column.getColumnName(), column.isNullable(), column.getColumnDefinition(), idx);
        int sqlType = this.getSqlType(computedColumn);
        QPath qPath = QPathFactory.create(parent, computedColumn, sqlType);
        ColumnMetadata metadata = QColumnMetadataFactory.create(computedColumn, sqlType);
        this.paths.put(qPath, metadata);
    }

    private List<QEntityColumnMetadata> getForeignColumns(QEntityJoinColumnMetadata column) {
        Q<Object> foreign = this.inverse ? EntityQL.qEntityWithoutMappings(this.parent.getType(), this.scanner) : EntityQL.qEntityWithoutMappings(column.getFieldType(), this.scanner);
        List<QEntityColumnMetadata> result = foreign.idColumns;
        if (this.isCustomForeignColumn(column)) {
            result = new ArrayList<QEntityColumnMetadata>();
            result.add(this.createCustomForeignColumn(this.inverse ? this.parent.getType() : column.getFieldType(), column));
        }
        return result;
    }

    private List<QEntityColumnMetadata> getForeignColumns(QEntityCompositeJoinColumnMetadata column) {
        LinkedList<QEntityColumnMetadata> result = new LinkedList<QEntityColumnMetadata>();
        column.getItems().forEach(item -> {
            if (!this.isCustomForeignColumn((ReferenceColumnInfoMetadata)item)) {
                throw new InvalidArgumentException(String.format("Composite FK requires a non-empty referencedColumnName: %s", item.getColumnName()));
            }
            result.add(this.createCustomForeignColumn(this.inverse ? this.parent.getType() : column.getFieldType(), (ReferenceColumnInfoMetadata)item));
        });
        return result;
    }

    private QEntityColumnMetadata createCustomForeignColumn(Class<?> fieldType, ReferenceColumnInfoMetadata column) {
        return QFactory.get(fieldType, this.scanner).getMetadata().getColumns().stream().filter(fc -> this.matchesCustomForeignColumnName(column, (QEntityColumnMetadata)fc)).findFirst().orElseThrow(() -> new InvalidArgumentException(String.format("Unable to find field mapped to Column '%s' in Entity %s", column.getReferencedColumnName(), fieldType.getName())));
    }

    private boolean matchesCustomForeignColumnName(ReferenceColumnInfoMetadata column, QEntityColumnMetadata foreignColumn) {
        return foreignColumn.getColumnName().equals(column.getReferencedColumnName());
    }

    private boolean isCustomForeignColumn(ReferenceColumnInfoMetadata column) {
        return !column.getReferencedColumnName().equals("");
    }

    private int getSqlType(QEntityColumnMetadata computedColumn) {
        return QSqlTypeProvider.get(computedColumn.getComputedFieldType()).map(t -> t.getSqlType(computedColumn.getColumnDefinition())).orElse(1111);
    }

    LinkedHashMap<QPath, ColumnMetadata> getPaths() {
        return this.paths;
    }

    LinkedList<String> getForeignColumnNames() {
        return this.inverse ? this.columnNames : this.foreignColumns.stream().map(QEntityColumnMetadata::getColumnName).collect(Collectors.toCollection(LinkedList::new));
    }
}

