/*
 * Decompiled with CFR 0.152.
 */
package pl.exsio.querydsl.entityql;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.extension.AbstractExtension;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import pl.exsio.querydsl.entityql.Q;
import pl.exsio.querydsl.entityql.ex.EntityQlExportException;

public class QExporter {
    private static final Map<Class<?>, Class<?>> PRIMITIVES = new HashMap();
    private final PebbleEngine engine = new PebbleEngine.Builder().extension(new Extension[]{new EntityQlExtension()}).allowUnsafeMethods(true).newLineTrimming(false).build();

    public <E> void export(Q<E> q, String fileNamePattern, String pkgName, String destinationPath) throws IOException {
        Class type = q.getType();
        String fileName = String.format(fileNamePattern, type.getSimpleName());
        Path filePath = this.getFilePath(pkgName, destinationPath, fileName);
        Lang lang = Lang.forName(fileName);
        String exportedClass = this.renderClass(q, pkgName, type, fileName, lang);
        FileUtils.writeStringToFile((File)new File(filePath.toUri()), (String)this.format(lang, exportedClass), (Charset)StandardCharsets.UTF_8);
    }

    private String format(Lang lang, String exportedClass) {
        if (lang.isGroovy()) {
            exportedClass = exportedClass.replaceAll(";", "");
        }
        return exportedClass.replaceAll("\\r\\n", " ").replaceAll("\\r", " ").replaceAll("\\n", " ").replaceAll("\\s+", " ").replaceAll("~nl~", "\n").replaceAll("~", " ").replaceAll("\\( ", "(").replaceAll("< ", "<").replaceAll(" >", ">").replaceAll(">=", "> =").replaceAll(">\\{", "> {").replaceAll(" \\)", ")").replaceAll(" ,", ",").replaceAll(",", ", ").replaceAll(",\\s+", ", ");
    }

    private Path getFilePath(String pkgName, String destinationPath, String fileName) {
        ArrayList<String> pathElements = new ArrayList<String>(Arrays.asList(pkgName.split("\\.")));
        pathElements.add(fileName);
        return Paths.get(destinationPath, pathElements.toArray(new String[0]));
    }

    private <E> String renderClass(Q<E> q, String pkgName, Class<? extends E> type, String fileName, Lang lang) {
        String className = FilenameUtils.removeExtension((String)fileName);
        PebbleTemplate template = this.engine.getTemplate(lang.getTemplateName());
        Map<String, Object> context = this.getContext(q, pkgName, type, className, lang);
        return this.doRender(template, context);
    }

    private String doRender(PebbleTemplate template, Map<String, Object> context) {
        StringWriter writer = new StringWriter();
        try {
            template.evaluate((Writer)writer, context);
        }
        catch (Exception ex) {
            throw new EntityQlExportException(ex);
        }
        return ((Object)writer).toString();
    }

    private <E> Map<String, Object> getContext(Q<E> q, String pkgName, Class<? extends E> type, String className, Lang lang) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("package", pkgName);
        context.put("className", className);
        context.put("entityName", type.getName());
        context.put("entitySimpleName", type.getSimpleName());
        context.put("entityClass", type);
        context.put("exporterName", this.getClass().getName());
        context.put("uid", this.getHash(q));
        context.put("q", q);
        context.put("idCols", q.idColumns);
        context.put("isGroovy", lang.isGroovy());
        context.put("imports", new ArrayList());
        return context;
    }

    private <E> int getHash(Q<E> q) {
        return Objects.hash(q.columns().keySet(), q.joinColumns().keySet(), q.inverseJoinColumns().keySet());
    }

    static {
        PRIMITIVES.put(Integer.TYPE, Integer.class);
        PRIMITIVES.put(Float.TYPE, Float.class);
        PRIMITIVES.put(Double.TYPE, Double.class);
        PRIMITIVES.put(Byte.TYPE, Byte.class);
        PRIMITIVES.put(Short.TYPE, Short.class);
        PRIMITIVES.put(Character.TYPE, Character.class);
        PRIMITIVES.put(Long.TYPE, Long.class);
        PRIMITIVES.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES.put(Void.TYPE, Void.class);
    }

    private static enum Lang {
        JAVA("staticTemplate.peb"),
        GROOVY("staticTemplate.peb"),
        KOTLIN("staticTemplateKt.peb");

        private final String templateName;

        private Lang(String templateName) {
            this.templateName = templateName;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        private static Lang forName(String fileName) {
            if (fileName.endsWith("kt")) {
                return KOTLIN;
            }
            if (fileName.endsWith("groovy")) {
                return GROOVY;
            }
            return JAVA;
        }

        public boolean isGroovy() {
            return GROOVY.equals((Object)this);
        }
    }

    public static class Replace
    implements Function {
        public List<String> getArgumentNames() {
            ArrayList<String> names = new ArrayList<String>();
            names.add("target");
            names.add("toReplace");
            names.add("replaceWith");
            return names;
        }

        public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
            String target = (String)args.get("target");
            String toReplace = (String)args.get("toReplace");
            String replaceWith = (String)args.get("replaceWith");
            return target.replace(toReplace, replaceWith);
        }
    }

    public static class Capitalize
    implements Function {
        public List<String> getArgumentNames() {
            ArrayList<String> names = new ArrayList<String>();
            names.add("target");
            return names;
        }

        public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
            String target = (String)args.get("target");
            return target.substring(0, 1).toUpperCase() + target.substring(1);
        }
    }

    public static class IsParametrized
    implements Function {
        public List<String> getArgumentNames() {
            ArrayList<String> names = new ArrayList<String>();
            names.add("target");
            return names;
        }

        public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
            return ((Class)args.get("target")).getTypeParameters().length > 0;
        }
    }

    public static class isValidImport
    implements Function {
        public List<String> getArgumentNames() {
            ArrayList<String> names = new ArrayList<String>();
            names.add("target");
            names.add("imports");
            return names;
        }

        public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
            Class target = (Class)args.get("target");
            List imports = (List)args.get("imports");
            if (target.isPrimitive() || target.getPackage().getName().equals("java.lang") || imports.contains(target.getName())) {
                return false;
            }
            imports.add(target.getName());
            return true;
        }
    }

    public static class PrimitiveWrapper
    implements Function {
        public List<String> getArgumentNames() {
            ArrayList<String> names = new ArrayList<String>();
            names.add("target");
            return names;
        }

        public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
            Class target = (Class)args.get("target");
            Class wrapped = (Class)PRIMITIVES.get(target);
            return wrapped != null ? wrapped : target;
        }
    }

    public static class EntityQlExtension
    extends AbstractExtension {
        public Map<String, Function> getFunctions() {
            HashMap<String, Function> functions = new HashMap<String, Function>();
            functions.put("wrapPrimitive", new PrimitiveWrapper());
            functions.put("isValidImport", new isValidImport());
            functions.put("isParametrized", new IsParametrized());
            functions.put("capitalize", new Capitalize());
            functions.put("replace", new Replace());
            return functions;
        }
    }
}

