/*
 * Decompiled with CFR 0.152.
 */
package com.github.dzieciou.testing.curl;

import com.github.dzieciou.testing.curl.Http2Curl;
import com.github.dzieciou.testing.curl.Options;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurlLoggingInterceptor
implements HttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)"curl");
    private final Options options;
    private final Http2Curl http2Curl;

    public CurlLoggingInterceptor(Options options) {
        this.options = options;
        this.http2Curl = new Http2Curl(options);
    }

    private static void printStacktrace(StringBuffer sb) {
        StackTraceElement[] trace;
        for (StackTraceElement traceElement : trace = Thread.currentThread().getStackTrace()) {
            sb.append("\tat ").append(traceElement).append(System.lineSeparator());
        }
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        try {
            String curl = this.http2Curl.generateCurl(request);
            StringBuffer message = new StringBuffer(curl);
            if (this.options.canLogStacktrace()) {
                message.append(String.format("%n\tgenerated%n", new Object[0]));
                CurlLoggingInterceptor.printStacktrace(message);
            }
            log.debug(message.toString());
        }
        catch (Exception e) {
            log.warn("Failed to generate CURL command for HTTP request", (Throwable)e);
        }
    }
}

