/*
 * Decompiled with CFR 0.152.
 */
package com.github.dyvoker.dialogs.context_menu;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.dyvoker.dialogs.R;
import com.github.dyvoker.dialogs.context_menu.ClickListener;
import com.github.dyvoker.dialogs.context_menu.ContextMenuItemWidget;

public class IconMenuItem
implements ContextMenuItemWidget {
    @NonNull
    private final View root;
    private ContextMenuItemWidget.DismissListener dismissListener;

    private IconMenuItem(@NonNull View root, final @Nullable ClickListener clickListener, final boolean dismissOnClick) {
        this.root = root;
        this.getRoot().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (clickListener != null) {
                    clickListener.onClick();
                }
                if (dismissOnClick && IconMenuItem.this.dismissListener != null) {
                    IconMenuItem.this.dismissListener.dismissMenu();
                }
            }
        });
    }

    @Override
    public void setDismissListener(@NonNull ContextMenuItemWidget.DismissListener dismissListener) {
        this.dismissListener = dismissListener;
    }

    @Override
    @NonNull
    public View getRoot() {
        return this.root;
    }

    @NonNull
    public static Builder newBuilder(@NonNull Context context, @NonNull CharSequence text, @NonNull Drawable icon) {
        return new Builder(context, text, icon);
    }

    @NonNull
    public static Builder newBuilder(@NonNull Context context, @StringRes int textId, @DrawableRes int iconId) {
        return new Builder(context, context.getString(textId), context.getResources().getDrawable(iconId));
    }

    public static class Builder {
        @NonNull
        private final View root;
        @Nullable
        private ClickListener clickListener;
        private boolean dismissOnClick = true;

        private Builder(@NonNull Context context, @NonNull CharSequence text, @NonNull Drawable icon) {
            LayoutInflater inflater = LayoutInflater.from((Context)context);
            this.root = inflater.inflate(R.layout.dialogs_dyv_icon_text_item, null, false);
            TextView textView = (TextView)this.root.findViewById(R.id.dialogs_dyv_text);
            textView.setText(text);
            ImageView iconView = (ImageView)this.root.findViewById(R.id.dialogs_dyv_icon);
            iconView.setImageDrawable(icon);
        }

        @NonNull
        public Builder clickListener(@NonNull ClickListener clickListener) {
            this.clickListener = clickListener;
            return this;
        }

        @NonNull
        public Builder dismissOnClick(boolean dismissOnClick) {
            this.dismissOnClick = dismissOnClick;
            return this;
        }

        @NonNull
        public IconMenuItem build() {
            return new IconMenuItem(this.root, this.clickListener, this.dismissOnClick);
        }
    }
}

