/*
 * Decompiled with CFR 0.152.
 */
package com.github.dyvoker.dialogs;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.view.View;
import android.widget.TextView;
import com.github.dyvoker.dialogs.R;

public class SimpleHintDialogWidget {
    @NonNull
    private final Context context;
    @NonNull
    private final CharSequence title;
    @NonNull
    private final CharSequence text;
    @Nullable
    private final CharSequence buttonText;
    @ColorInt
    private final int titleColor;
    @ColorInt
    private final int textColor;
    @ColorInt
    private final int buttonTextColor;
    private final boolean isCanceledOnTouchOutside;
    private Dialog dialog;

    SimpleHintDialogWidget(@NonNull Context context, @NonNull CharSequence title, @NonNull CharSequence text, @Nullable CharSequence buttonText, @ColorInt int titleColor, @ColorInt int textColor, @ColorInt int buttonTextColor, boolean isCanceledOnTouchOutside) {
        this.context = context;
        this.title = title;
        this.text = text;
        this.buttonText = buttonText;
        this.titleColor = titleColor;
        this.textColor = textColor;
        this.buttonTextColor = buttonTextColor;
        this.isCanceledOnTouchOutside = isCanceledOnTouchOutside;
    }

    public void create() {
        this.dialog = new Dialog(this.context);
        this.dialog.requestWindowFeature(1);
        this.dialog.setCanceledOnTouchOutside(this.isCanceledOnTouchOutside);
        this.dialog.setContentView(R.layout.dialogs_dyv_hint);
        TextView titleView = (TextView)this.dialog.findViewById(R.id.dialogs_dyv_title);
        titleView.setText(this.title);
        titleView.setTextColor(this.titleColor);
        TextView textView = (TextView)this.dialog.findViewById(R.id.dialogs_dyv_text);
        textView.setText(this.text);
        textView.setTextColor(this.textColor);
        TextView okButton = (TextView)this.dialog.findViewById(R.id.dialogs_dyv_ok);
        if (this.buttonText != null) {
            okButton.setText(this.buttonText);
        }
        okButton.setTextColor(this.buttonTextColor);
        okButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SimpleHintDialogWidget.this.dismiss();
            }
        });
    }

    public void show() {
        if (this.dialog == null) {
            this.create();
        }
        this.dialog.show();
    }

    public void dismiss() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
    }

    @Nullable
    public Dialog getDialog() {
        return this.dialog;
    }

    public static Builder newBuilder(@NonNull Context context, @StringRes int title, @StringRes int text) {
        return new Builder(context, context.getResources().getString(title), context.getResources().getString(text));
    }

    public static Builder newBuilder(@NonNull Context context, @NonNull CharSequence title, @NonNull CharSequence text) {
        return new Builder(context, title, text);
    }

    public static class Builder {
        @NonNull
        private final Context context;
        @NonNull
        private final CharSequence title;
        @NonNull
        private final CharSequence text;
        @Nullable
        private CharSequence buttonText;
        @ColorInt
        private int titleColor;
        @ColorInt
        private int textColor;
        @ColorInt
        private int buttonTextColor;
        private boolean isCanceledOnTouchOutside = true;

        private Builder(@NonNull Context context, @NonNull CharSequence title, @NonNull CharSequence text) {
            this.context = context;
            this.title = title;
            this.text = text;
            this.titleColor = context.getResources().getColor(R.color.dialogs_dyv_black);
            this.textColor = context.getResources().getColor(R.color.dialogs_dyv_black);
            this.buttonTextColor = context.getResources().getColor(R.color.dialogs_dyv_button_color);
        }

        @NonNull
        public Builder buttonText(@StringRes int buttonText) {
            this.buttonText = this.context.getResources().getString(buttonText);
            return this;
        }

        @NonNull
        public Builder buttonText(@NonNull CharSequence buttonText) {
            this.buttonText = buttonText;
            return this;
        }

        @NonNull
        public Builder titleColor(@ColorInt int titleColor) {
            this.titleColor = titleColor;
            return this;
        }

        @NonNull
        public Builder titleColorRes(@ColorRes int titleColor) {
            this.titleColor = this.context.getResources().getColor(titleColor);
            return this;
        }

        @NonNull
        public Builder textColor(@ColorInt int textColor) {
            this.textColor = textColor;
            return this;
        }

        @NonNull
        public Builder textColorRes(@ColorRes int textColor) {
            this.textColor = this.context.getResources().getColor(textColor);
            return this;
        }

        @NonNull
        public Builder buttonTextColor(@ColorInt int buttonTextColor) {
            this.buttonTextColor = buttonTextColor;
            return this;
        }

        @NonNull
        public Builder buttonTextColorRes(@ColorRes int buttonTextColor) {
            this.buttonTextColor = this.context.getResources().getColor(buttonTextColor);
            return this;
        }

        @NonNull
        public Builder isCanceledOnTouchOutside(boolean isCanceledOnTouchOutside) {
            this.isCanceledOnTouchOutside = isCanceledOnTouchOutside;
            return this;
        }

        @NonNull
        public SimpleHintDialogWidget build() {
            return new SimpleHintDialogWidget(this.context, this.title, this.text, this.buttonText, this.titleColor, this.textColor, this.buttonTextColor, this.isCanceledOnTouchOutside);
        }
    }
}

