/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.widget;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.dueeeke.videoplayer.R;

public class StatusView
extends LinearLayout {
    private TextView tvMessage;
    private TextView btnAction;
    private ImageView ivClose;
    private float downX;
    private float downY;

    public StatusView(Context context) {
        this(context, null);
    }

    public StatusView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        View root = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_status_view, (ViewGroup)this);
        this.tvMessage = (TextView)root.findViewById(R.id.message);
        this.btnAction = (TextView)root.findViewById(R.id.status_btn);
        this.ivClose = (ImageView)root.findViewById(R.id.btn_close);
        this.setBackgroundResource(17170444);
        this.setClickable(true);
    }

    public void setMessage(String msg) {
        if (this.tvMessage != null) {
            this.tvMessage.setText((CharSequence)msg);
        }
    }

    public void setButtonTextAndAction(String text, View.OnClickListener listener) {
        if (this.btnAction != null) {
            this.btnAction.setText((CharSequence)text);
            this.btnAction.setOnClickListener(listener);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.downX = ev.getX();
                this.downY = ev.getY();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float absDeltaX = Math.abs(ev.getX() - this.downX);
                float absDeltaY = Math.abs(ev.getY() - this.downY);
                if (!(absDeltaX > (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop()) && !(absDeltaY > (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop())) break;
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return super.dispatchTouchEvent(ev);
    }
}

